/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.gui.GuiBetterAdvancement;
import betteradvancements.gui.GuiBetterAdvancementTab;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBetterAdvancements
extends GuiScreen
implements ClientAdvancementManager.IListener {
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final ClientAdvancementManager clientAdvancementManager;
    private final Map<Advancement, GuiBetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private GuiBetterAdvancementTab selectedTab;
    private int scrollMouseX;
    private int scrollMouseY;
    private float zoom = 1.0f;
    private boolean isScrolling;

    public GuiScreenBetterAdvancements(ClientAdvancementManager clientAdvancementManager) {
        this.clientAdvancementManager = clientAdvancementManager;
    }

    public void func_73866_w_() {
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancementManager.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancementManager.func_194230_a(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancementManager.func_194230_a(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
    }

    public void func_146281_b() {
        this.clientAdvancementManager.func_192798_a(null);
        NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.func_147114_u();
        if (nethandlerplayclient != null) {
            nethandlerplayclient.func_147297_a((Packet)CPacketSeenAdvancements.func_194164_a());
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (GuiBetterAdvancementTab guiBetterAdvancementTab : this.tabs.values()) {
                if (!guiBetterAdvancementTab.isMouseOver(30, 40, this.field_146294_l - 60, this.field_146295_m - 40 - 30, mouseX, mouseY)) continue;
                this.clientAdvancementManager.func_194230_a(guiBetterAdvancementTab.getAdvancement(), true);
                break;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getDWheel();
        if (wheel < 0 && this.zoom > 1.0f) {
            this.zoom -= 0.2f;
        } else if (wheel > 0 && this.zoom < 2.0f) {
            this.zoom += 0.2f;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == this.field_146297_k.field_71474_y.field_194146_ao.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (Mouse.isButtonDown((int)0)) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseX - this.scrollMouseX, mouseY - this.scrollMouseY, this.field_146294_l - 60 - 18, this.field_146295_m - 40 - 30 - 27);
            }
            this.scrollMouseX = mouseX;
            this.scrollMouseY = mouseY;
        } else {
            this.isScrolling = false;
        }
        this.func_146276_q_();
        this.renderInside(mouseX, mouseY, 30, 40, this.field_146294_l - 30, this.field_146295_m - 30);
        this.renderWindow(30, 40, this.field_146294_l - 30, this.field_146295_m - 30);
        this.renderToolTips(mouseX, mouseY, 30, 40, this.field_146294_l - 30, this.field_146295_m - 30);
    }

    private void renderInside(int mouseX, int mouseY, int left, int top, int right, int bottom) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (guiBetterAdvancementTab == null) {
            GuiScreenBetterAdvancements.func_73734_a((int)boxLeft, (int)boxTop, (int)boxRight, (int)boxBottom, (int)-16777216);
            String s = I18n.func_135052_a((String)"advancements.empty", (Object[])new Object[0]);
            int i = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, boxLeft + (width - i) / 2, boxTop + height / 2 - this.field_146289_q.field_78288_b, -1);
            this.field_146289_q.func_78276_b(":(", boxLeft + (width - this.field_146289_q.func_78256_a(":(")) / 2, boxTop + height / 2 + this.field_146289_q.field_78288_b, -1);
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)boxLeft, (float)boxTop, (float)-400.0f);
            GlStateManager.func_179126_j();
            guiBetterAdvancementTab.drawContents(width, height);
            GlStateManager.func_179121_F();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179097_i();
        }
    }

    public void renderWindow(int left, int top, int right, int bottom) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        this.field_146297_k.func_110434_K().func_110577_a(Resources.Gui.WINDOW);
        this.func_73729_b(left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left + 30, 40, this.field_146294_l - left - 30 - 30 - 30, 30, 30, 0, 192, 30);
        this.func_73729_b(right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left, top + 30, 30, bottom - top - 30, 0, 30, 30, 80);
        RenderUtil.renderRepeating((Gui)this, right - 30, top + 30, 30, bottom - top - 30, 222, 30, 30, 80);
        this.func_73729_b(left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left + 30, bottom - 30, this.field_146294_l - left - 30 - 30 - 30, 30, 30, 110, 192, 30);
        this.func_73729_b(right - 30, bottom - 30, 222, 110, 30, 30);
        if (this.tabs.size() > 1) {
            this.field_146297_k.func_110434_K().func_110577_a(Resources.Gui.TABS);
            int width = right - left;
            int height = bottom - top;
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                tab.drawTab(left, top, width, height, tab == this.selectedTab);
            }
            GlStateManager.func_179091_B();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74520_c();
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                tab.drawIcon(left, top, width, height, this.field_146296_j);
            }
            GlStateManager.func_179084_k();
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.advancements", (Object[])new Object[0]), left + 8, top + 6, 0x404040);
    }

    private void renderToolTips(int mouseX, int mouseY, int left, int top, int right, int bottom) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)(left + 9), (float)(top + 18), (float)400.0f);
            this.selectedTab.drawToolTips(mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                this.func_146279_a(tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void func_191931_a(@Nonnull Advancement advancement) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = GuiBetterAdvancementTab.create(this.field_146297_k, this, this.tabs.size(), advancement, this.field_146294_l - 60, this.field_146295_m - 40 - 30);
        if (guiBetterAdvancementTab != null) {
            this.tabs.put(advancement, guiBetterAdvancementTab);
        }
    }

    public void func_191928_b(@Nonnull Advancement advancementIn) {
    }

    public void func_191932_c(@Nonnull Advancement advancementIn) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.getTab(advancementIn);
        if (guiBetterAdvancementTab != null) {
            guiBetterAdvancementTab.addAdvancement(advancementIn);
        }
    }

    public void func_191929_d(@Nonnull Advancement advancementIn) {
    }

    public void func_191933_a(@Nonnull Advancement advancement, @Nonnull AdvancementProgress advancementProgress) {
        GuiBetterAdvancement guiBetterAdvancement = this.getAdvancementGui(advancement);
        if (guiBetterAdvancement != null) {
            guiBetterAdvancement.getAdvancementProgress(advancementProgress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancement) {
        this.selectedTab = this.tabs.get(advancement);
    }

    public void func_191930_a() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public GuiBetterAdvancement getAdvancementGui(Advancement advancement) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.getTab(advancement);
        return guiBetterAdvancementTab == null ? null : guiBetterAdvancementTab.getAdvancementGui(advancement);
    }

    @Nullable
    private GuiBetterAdvancementTab getTab(@Nonnull Advancement advancement) {
        while (advancement.func_192070_b() != null) {
            advancement = advancement.func_192070_b();
        }
        return this.tabs.get(advancement);
    }
}

