/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import net.minecraftforge.server.command.TextComponentHelper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class CommandEntity
extends CommandTreeBase {
    public CommandEntity() {
        this.addSubcommand((bk)new EntityListCommand());
        this.addSubcommand((bk)new CommandTreeHelp(this));
    }

    public String b(bn sender) {
        return "commands.forge.entity.usage";
    }

    public int a() {
        return 2;
    }

    public String c() {
        return "entity";
    }

    private static class EntityListCommand
    extends bi {
        private EntityListCommand() {
        }

        public String c() {
            return "list";
        }

        public int a() {
            return 2;
        }

        public String b(bn sender) {
            return "commands.forge.entity.list.usage";
        }

        public void a(MinecraftServer server, bn sender, String[] args) throws ei {
            String filter = "*";
            if (args.length > 0) {
                filter = args[0];
            }
            String cleanFilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = vi.a().stream().filter(n2 -> n2.toString().matches(cleanFilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw new ep("commands.forge.entity.list.invalid", new Object[0]);
            }
            int dim = args.length > 1 ? EntityListCommand.a((String)args[1]) : sender.e().s.getDimension();
            oo world = DimensionManager.getWorld(dim);
            if (world == null) {
                throw new ep("commands.forge.entity.list.invalidworld", new Object[]{dim});
            }
            HashMap list = Maps.newHashMap();
            List entities = world.e;
            entities.forEach(e2 -> {
                nf key = vi.a((vg)e2);
                MutablePair info = list.computeIfAbsent(key, k2 -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                amn chunk = new amn(e2.c());
                MutablePair mutablePair = info;
                Integer n2 = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                Integer n3 = mutablePair.left;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
            });
            if (names.size() == 1) {
                nf name = (nf)names.iterator().next();
                Pair info = (Pair)list.get(name);
                if (info == null) {
                    throw new ep("commands.forge.entity.list.none", new Object[0]);
                }
                sender.a((hh)TextComponentHelper.createComponentTranslation(sender, "commands.forge.entity.list.single.header", name, info.getLeft()));
                ArrayList toSort = new ArrayList();
                toSort.addAll(((Map)info.getRight()).entrySet());
                toSort.sort((a2, b2) -> {
                    if (Objects.equals(a2.getValue(), b2.getValue())) {
                        return ((amn)a2.getKey()).toString().compareTo(((amn)b2.getKey()).toString());
                    }
                    return (Integer)b2.getValue() - (Integer)a2.getValue();
                });
                long limit = 10L;
                for (Map.Entry entry : toSort) {
                    if (limit-- != 0L) {
                        sender.a((hh)new ho("  " + entry.getValue() + ": " + ((amn)entry.getKey()).a + ", " + ((amn)entry.getKey()).b));
                        continue;
                    }
                    break;
                }
            } else {
                ArrayList info = new ArrayList();
                list.forEach((key, value) -> {
                    if (names.contains(key)) {
                        Pair of = Pair.of((Object)key, (Object)value.left);
                        info.add(of);
                    }
                });
                info.sort((a2, b2) -> {
                    if (Objects.equals(a2.getRight(), b2.getRight())) {
                        return ((nf)a2.getKey()).toString().compareTo(((nf)b2.getKey()).toString());
                    }
                    return (Integer)b2.getRight() - (Integer)a2.getRight();
                });
                if (info.size() == 0) {
                    throw new ep("commands.forge.entity.list.none", new Object[0]);
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                sender.a((hh)TextComponentHelper.createComponentTranslation(sender, "commands.forge.entity.list.multiple.header", count));
                info.forEach(e2 -> sender.a((hh)new ho("  " + e2.getValue() + ": " + e2.getKey())));
            }
        }

        public List<String> a(MinecraftServer server, bn sender, String[] args, @Nullable et targetPos) {
            if (args.length == 1) {
                String[] entityNames = (String[])vi.a().stream().map(nf::toString).sorted().toArray(String[]::new);
                return EntityListCommand.a((String[])args, (String[])entityNames);
            }
            return Collections.emptyList();
        }
    }
}

