/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.shaper.ComposerTileEntity;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendComposerData
implements IMessage {
    private BlockPos pos;
    private ShapeModifier[] modifiers;

    public void fromBytes(ByteBuf buf) {
        int s = buf.readInt();
        this.modifiers = new ShapeModifier[s];
        for (int i = 0; i < s; ++i) {
            String code = NetworkTools.readString((ByteBuf)buf);
            ShapeOperation op = ShapeOperation.getByName(code);
            boolean flip = buf.readBoolean();
            code = NetworkTools.readString((ByteBuf)buf);
            ShapeRotation rot = ShapeRotation.getByName(code);
            this.modifiers[i] = new ShapeModifier(op, flip, rot);
        }
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modifiers.length);
        for (ShapeModifier modifier : this.modifiers) {
            NetworkTools.writeString((ByteBuf)buf, (String)modifier.getOperation().getCode());
            buf.writeBoolean(modifier.isFlipY());
            NetworkTools.writeString((ByteBuf)buf, (String)modifier.getRotation().getCode());
        }
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketSendComposerData() {
    }

    public PacketSendComposerData(BlockPos pos, ShapeModifier[] modifiers) {
        this.pos = pos;
        this.modifiers = modifiers;
    }

    public static class Handler
    implements IMessageHandler<PacketSendComposerData, IMessage> {
        public IMessage onMessage(PacketSendComposerData message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendComposerData message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.pos);
            if (te instanceof ComposerTileEntity) {
                ((ComposerTileEntity)te).setModifiers(message.modifiers);
            }
        }
    }
}

