/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.List;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.screenmodules.StorageControlModuleItem;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageModuleTabletItem
extends GenericRFToolsItem
implements IEnergyItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    public static final int DAMAGE_EMPTY = 0;
    public static final int DAMAGE_FULL = 1;
    public static final int DAMAGE_SCANNER = 2;
    public static final int META_FOR_SCANNER = 666;

    public StorageModuleTabletItem() {
        super("storage_module_tablet");
        this.func_77625_d(1);
        this.capacity = ModularStorageConfiguration.TABLET_MAXENERGY;
        this.maxReceive = ModularStorageConfiguration.TABLET_RECEIVEPERTICK;
        this.maxExtract = ModularStorageConfiguration.TABLET_CONSUMEPERUSE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_190926_b() != newStack.func_190926_b()) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory"), new ModelResourceLocation(this.getRegistryName(), "inventory")});
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_scanner", "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            int rfNeeded;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("childDamage")) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This tablet contains no storage module!"));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            int moduleDamage = tagCompound.func_74762_e("childDamage");
            if (moduleDamage == 666) {
                rfNeeded = ModularStorageConfiguration.TABLET_CONSUMEPERUSE_SCANNER;
            } else {
                rfNeeded = ModularStorageConfiguration.TABLET_CONSUMEPERUSE;
                if (moduleDamage != 6) {
                    rfNeeded += ModularStorageConfiguration.TABLET_EXTRACONSUME * (moduleDamage + 1);
                }
            }
            int energy = tagCompound.func_74762_e("Energy");
            if (energy < rfNeeded) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Not enough energy to open the contents!"));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            tagCompound.func_74768_a("Energy", energy -= rfNeeded);
            if (moduleDamage == 666) {
                if (tagCompound.func_74764_b("monitorx")) {
                    int monitordim = tagCompound.func_74762_e("monitordim");
                    int monitorx = tagCompound.func_74762_e("monitorx");
                    int monitory = tagCompound.func_74762_e("monitory");
                    int monitorz = tagCompound.func_74762_e("monitorz");
                    BlockPos pos = new BlockPos(monitorx, monitory, monitorz);
                    WorldServer w = DimensionManager.getWorld((int)monitordim);
                    if (w == null || !WorldTools.chunkLoaded((World)w, (BlockPos)pos)) {
                        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage scanner is out of range!"), false);
                    } else {
                        player.openGui((Object)RFTools.instance, RFTools.GUI_REMOTE_STORAGESCANNER_ITEM, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage module is not linked to a storage scanner!"), false);
                }
            } else if (moduleDamage == 6) {
                if (!tagCompound.func_74764_b("id")) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This remote storage module is not linked!"));
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                player.openGui((Object)RFTools.instance, RFTools.GUI_REMOTE_STORAGE_ITEM, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                player.openGui((Object)RFTools.instance, RFTools.GUI_MODULAR_STORAGE_ITEM, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77952_i() != 0;
    }

    public Item func_77668_q() {
        return ModularStorageSetup.storageModuleTabletItem;
    }

    public boolean func_77645_m() {
        return super.func_77645_m();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.hasContainerItem(stack) && stack.func_77942_o()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("Energy", stack.func_77978_p().func_74762_e("Energy"));
            if (stack.func_77978_p().func_74764_b("grid")) {
                tagCompound.func_74782_a("grid", stack.func_77978_p().func_74781_a("grid"));
            }
            ItemStack container = new ItemStack(this.func_77668_q());
            container.func_77982_d(tagCompound);
            return container;
        }
        return ItemStack.field_190927_a;
    }

    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
            if (itemStack.func_77952_i() == 1) {
                int max = StorageModuleItem.MAXSIZE[tagCompound.func_74762_e("childDamage")];
                StorageModuleItem.addModuleInformation(list, max, tagCompound);
            } else if (itemStack.func_77952_i() == 2) {
                list.add(TextFormatting.YELLOW + "Storage scanner module installed!");
                StorageControlModuleItem.addModuleInformation(list, itemStack);
            } else {
                list.add(TextFormatting.YELLOW + "No storage module installed!");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This RF/charged tablet can hold a storage module");
            list.add("and allows the wielder to manipulate the contents of");
            list.add("this module (remote or normal).");
            list.add("You can also craft this with a storage control");
            list.add("screen module for remote access to a storage scanner");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, EnergyTools.unsignedClampToInt((long)maxExtract)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }
}

