/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storagemonitor.PacketReturnInventoryInfo;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetInventoryInfo
implements IMessage {
    private int id;
    private BlockPos pos;
    private boolean doscan;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
        this.doscan = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        byteBuf.writeInt(this.id);
        byteBuf.writeBoolean(this.doscan);
    }

    public PacketGetInventoryInfo() {
    }

    public PacketGetInventoryInfo(int worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scannerTileEntity.findInventories() : scannerTileEntity.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$0((World)world, scannerTileEntity, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(World world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
            block = null;
        } else if (world.func_175623_d(pos)) {
            displayName = "[REMOVED]";
            block = null;
        } else {
            ModularStorageTileEntity storageTileEntity;
            ItemStack storageModule;
            displayName = BlockTools.getReadableName((World)world, (BlockPos)pos);
            TileEntity storageTe = world.func_175625_s(pos);
            if (storageTe instanceof ModularStorageTileEntity && !(storageModule = (storageTileEntity = (ModularStorageTileEntity)storageTe).func_70301_a(0)).func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                displayName = storageModule.func_82833_r();
            }
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), block);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$0(World world, StorageScannerTileEntity scannerTileEntity, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scannerTileEntity);
    }

    public static class Handler
    implements IMessageHandler<PacketGetInventoryInfo, IMessage> {
        public IMessage onMessage(PacketGetInventoryInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> message.onMessageServer(ctx.getServerHandler().field_147369_b).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, ctx.getServerHandler().field_147369_b)));
            return null;
        }

        private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, EntityPlayerMP player) {
            PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
            RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
        }
    }
}

