/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.PacketGetFilters;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.ShieldTileEntity;
import mcjty.rftools.blocks.shield.ShieldTileEntity2;
import mcjty.rftools.blocks.shield.ShieldTileEntity3;
import mcjty.rftools.blocks.shield.ShieldTileEntity4;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiShield
extends GenericGuiContainer<ShieldTEBase> {
    public static final int SHIELD_WIDTH = 256;
    public static final int SHIELD_HEIGHT = 224;
    public static final String ACTION_PASS = "Pass";
    public static final String ACTION_SOLID = "Solid";
    public static final String ACTION_DAMAGE = "Damage";
    public static final String ACTION_SOLIDDAMAGE = "SolDmg";
    public static final String DAMAGETYPE_GENERIC = DamageTypeMode.DAMAGETYPE_GENERIC.getDescription();
    public static final String DAMAGETYPE_PLAYER = DamageTypeMode.DAMAGETYPE_PLAYER.getDescription();
    private EnergyBar energyBar;
    private ChoiceLabel visibilityOptions;
    private ChoiceLabel actionOptions;
    private ChoiceLabel typeOptions;
    private ChoiceLabel damageType;
    private WidgetList filterList;
    private TextField player;
    private Button addFilter;
    private Button delFilter;
    private Button upFilter;
    private Button downFilter;
    private ColorSelector colorSelector;
    private List<ShieldFilter> filters = null;
    private int listDirty = 0;
    private static List<ShieldFilter> fromServer_filters = new ArrayList<ShieldFilter>();
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/shieldprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public static void storeFiltersForClient(List<ShieldFilter> filters) {
        fromServer_filters = new ArrayList<ShieldFilter>(filters);
    }

    public GuiShield(ShieldTileEntity shieldTileEntity, ShieldContainer container) {
        this((ShieldTEBase)shieldTileEntity, container);
    }

    public GuiShield(ShieldTileEntity2 shieldTileEntity, ShieldContainer container) {
        this((ShieldTEBase)shieldTileEntity, container);
    }

    public GuiShield(ShieldTileEntity3 shieldTileEntity, ShieldContainer container) {
        this((ShieldTEBase)shieldTileEntity, container);
    }

    public GuiShield(ShieldTileEntity4 shieldTileEntity, ShieldContainer container) {
        this((ShieldTEBase)shieldTileEntity, container);
    }

    public GuiShield(ShieldTEBase shieldTileEntity, ShieldContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shieldTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "shield");
        GenericEnergyStorageTileEntity.setCurrentRF((long)shieldTileEntity.getStoredPower());
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        long maxEnergyStored = ((ShieldTEBase)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(12, 141, 10, 76)).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.initVisibilityMode();
        this.initActionOptions();
        this.initTypeOptions();
        ImageChoiceLabel redstoneMode = this.initRedstoneMode();
        this.initDamageType();
        this.filterList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("filters")).setDesiredHeight(120)).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget<?> parent, int index) {
                GuiShield.this.selectFilter();
            }
        });
        Slider filterSlider = (Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("filters").setDesiredWidth(11)).setDesiredHeight(120);
        Panel filterPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).setLayoutHint(12, 10, 154, 124)).addChildren(new Widget[]{this.filterList, filterSlider})).setFilledBackground(-6381922);
        Button applyCamo = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("camo")).setText("Set")).setTooltips(new String[]{"Set the camouflage block"})).setLayoutHint(46, 142, 30, 16);
        this.colorSelector = (ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector(this.field_146297_k, (Gui)this).setName("color")).setTooltips(new String[]{"Color for the shield"})).setLayoutHint(25, 177, 30, 16);
        ToggleButton light = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setName("light")).setCheckMarker(true).setText("L")).setTooltips(new String[]{"If pressed, light is blocked", "by the shield"})).setLayoutHint(56, 177, 23, 16);
        this.player = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Optional player name"})).setLayoutHint(170, 44, 80, 14);
        this.addFilter = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("addfilter")).setText("Add")).setTooltips(new String[]{"Add selected filter"})).setLayoutHint(4, 6, 36, 14);
        this.delFilter = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("delfilter")).setText("Del")).setTooltips(new String[]{"Delete selected filter"})).setLayoutHint(39, 6, 36, 14);
        this.upFilter = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("upfilter")).setText("Up")).setTooltips(new String[]{"Move filter up"})).setLayoutHint(4, 22, 36, 14);
        this.downFilter = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("downfilter")).setText("Down")).setTooltips(new String[]{"Move filter down"})).setLayoutHint(39, 22, 36, 14);
        Panel controlPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint(170, 58, 80, 43)).addChildren(new Widget[]{this.addFilter, this.delFilter, this.upFilter, this.downFilter})).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        Label lootingBonus = (Label)((Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setText("Looting:");
        ((Label)lootingBonus.setTooltips(new String[]{"Insert dimensional shards", "for looting bonus"})).setLayoutHint(160, 118, 60, 18);
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.energyBar, this.visibilityOptions, applyCamo, redstoneMode, filterPanel, this.actionOptions, this.typeOptions, this.player, controlPanel, this.damageType, this.colorSelector, lootingBonus, light});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.bind(RFToolsMessages.INSTANCE, "redstone", this.tileEntity, GenericTileEntity.VALUE_RSMODE.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "visibility", this.tileEntity, ShieldTEBase.VALUE_SHIELDVISMODE.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "damage", this.tileEntity, ShieldTEBase.VALUE_DAMAGEMODE.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "color", this.tileEntity, ShieldTEBase.VALUE_COLOR.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "light", this.tileEntity, ShieldTEBase.VALUE_LIGHT.getName());
        this.window.event("camo", (source, params) -> this.applyCamoToShield());
        this.window.event("addfilter", (source, params) -> this.addNewFilter());
        this.window.event("delfilter", (source, params) -> this.removeSelectedFilter());
        this.window.event("upfilter", (source, params) -> this.moveFilterUp());
        this.window.event("downfilter", (source, params) -> this.moveFilterDown());
        this.listDirty = 0;
        this.requestFilters();
        ((ShieldTEBase)this.tileEntity).requestRfFromServer("rftools");
    }

    private void selectFilter() {
        int selected = this.filterList.getSelected();
        if (selected != -1) {
            boolean damage;
            ShieldFilter shieldFilter = this.filters.get(selected);
            boolean solid = (shieldFilter.getAction() & 1) != 0;
            boolean bl = damage = (shieldFilter.getAction() & 2) != 0;
            if (solid && damage) {
                this.actionOptions.setChoice(ACTION_SOLIDDAMAGE);
            } else if (solid) {
                this.actionOptions.setChoice(ACTION_SOLID);
            } else if (damage) {
                this.actionOptions.setChoice(ACTION_DAMAGE);
            } else {
                this.actionOptions.setChoice(ACTION_PASS);
            }
            String type = shieldFilter.getFilterName();
            if ("default".equals(type)) {
                this.typeOptions.setChoice("All");
            } else if ("animal".equals(type)) {
                this.typeOptions.setChoice("Passive");
            } else if ("hostile".equals(type)) {
                this.typeOptions.setChoice("Hostile");
            } else if ("player".equals(type)) {
                this.typeOptions.setChoice("Player");
            } else if ("item".equals(type)) {
                this.typeOptions.setChoice("Item");
            }
            if (shieldFilter instanceof PlayerFilter) {
                this.player.setText(((PlayerFilter)shieldFilter).getName());
            } else {
                this.player.setText("");
            }
        }
    }

    private void requestFilters() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetFilters(((ShieldTEBase)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestFilters();
            this.listDirty = 20;
        }
    }

    private void populateFilters() {
        ArrayList<ShieldFilter> newFilters = new ArrayList<ShieldFilter>(fromServer_filters);
        if (newFilters.equals(this.filters)) {
            return;
        }
        this.filters = new ArrayList<ShieldFilter>(newFilters);
        this.filterList.removeChildren();
        for (ShieldFilter filter : this.filters) {
            boolean damage;
            PlayerFilter playerFilter;
            String n = "player".equals(filter.getFilterName()) ? ((playerFilter = (PlayerFilter)filter).getName() == null || playerFilter.getName().isEmpty() ? "players" : "player " + playerFilter.getName()) : filter.getFilterName();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(n)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(85));
            boolean solid = (filter.getAction() & 1) != 0;
            boolean bl = damage = (filter.getAction() & 2) != 0;
            String actionName = solid && damage ? ACTION_SOLIDDAMAGE : (solid ? ACTION_SOLID : (damage ? ACTION_DAMAGE : ACTION_PASS));
            panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(actionName)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
            this.filterList.addChild((Widget)panel);
        }
    }

    private void moveFilterUp() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shield.upFilter", TypedMap.builder().put(ShieldTEBase.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void moveFilterDown() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shield.downFilter", TypedMap.builder().put(ShieldTEBase.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void addNewFilter() {
        String actionName = this.actionOptions.getCurrentChoice();
        int action = ACTION_PASS.equals(actionName) ? 0 : (ACTION_SOLID.equals(actionName) ? 1 : (ACTION_SOLIDDAMAGE.equals(actionName) ? 3 : 2));
        String filterName = this.typeOptions.getCurrentChoice();
        String type = "All".equals(filterName) ? "default" : ("Passive".equals(filterName) ? "animal" : ("Hostile".equals(filterName) ? "hostile" : ("Item".equals(filterName) ? "item" : "player")));
        String playerName = this.player.getText();
        int selected = this.filterList.getSelected();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shield.addFilter", TypedMap.builder().put(ShieldTEBase.PARAM_ACTION, (Object)action).put(ShieldTEBase.PARAM_TYPE, (Object)type).put(ShieldTEBase.PARAM_PLAYER, (Object)playerName).put(ShieldTEBase.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private void removeSelectedFilter() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shield.delFilter", TypedMap.builder().put(ShieldTEBase.PARAM_SELECTED, (Object)this.filterList.getSelected()).build());
        this.listDirty = 0;
    }

    private ImageChoiceLabel initRedstoneMode() {
        ImageChoiceLabel redstoneMode = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setName("redstone")).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        redstoneMode.setLayoutHint(62, 200, 16, 16);
        redstoneMode.setCurrentChoice(((ShieldTEBase)this.tileEntity).getRSMode().ordinal());
        return redstoneMode;
    }

    private void initVisibilityMode() {
        this.visibilityOptions = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setName("visibility")).setLayoutHint(25, 161, 54, 14);
        for (ShieldRenderingMode m : ShieldRenderingMode.values()) {
            if (!ShieldConfiguration.allowInvisibleShield && m == ShieldRenderingMode.MODE_INVISIBLE) continue;
            this.visibilityOptions.addChoices(new String[]{m.getDescription()});
        }
        if (ShieldConfiguration.allowInvisibleShield) {
            this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_INVISIBLE.getDescription(), new String[]{"Shield is completely invisible"});
        }
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SHIELD.getDescription(), new String[]{"Default shield texture"});
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_TRANSP.getDescription(), new String[]{"Transparent shield texture"});
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SOLID.getDescription(), new String[]{"Solid shield texture"});
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_MIMIC.getDescription(), new String[]{"Use the texture from the supplied block"});
    }

    private void initActionOptions() {
        this.actionOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(170, 12, 80, 14);
        this.actionOptions.addChoices(new String[]{ACTION_PASS, ACTION_SOLID, ACTION_DAMAGE, ACTION_SOLIDDAMAGE});
        this.actionOptions.setChoiceTooltip(ACTION_PASS, new String[]{"Entity that matches this filter", "can pass through"});
        this.actionOptions.setChoiceTooltip(ACTION_SOLID, new String[]{"Entity that matches this filter", "cannot pass"});
        this.actionOptions.setChoiceTooltip(ACTION_DAMAGE, new String[]{"Entity that matches this filter", "can pass but gets damage"});
        this.actionOptions.setChoiceTooltip(ACTION_SOLIDDAMAGE, new String[]{"Entity that matches this filter", "cannot pass and gets damage"});
    }

    private void initTypeOptions() {
        this.typeOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint(170, 28, 80, 14);
        this.typeOptions.addChoices(new String[]{"All", "Passive", "Hostile", "Item", "Player"});
        this.typeOptions.setChoiceTooltip("All", new String[]{"Matches everything"});
        this.typeOptions.setChoiceTooltip("Passive", new String[]{"Matches passive mobs"});
        this.typeOptions.setChoiceTooltip("Hostile", new String[]{"Matches hostile mobs"});
        this.typeOptions.setChoiceTooltip("Item", new String[]{"Matches items"});
        this.typeOptions.setChoiceTooltip("Player", new String[]{"Matches players", "(optionally named)"});
    }

    private void initDamageType() {
        this.damageType = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setName("damage")).setLayoutHint(170, 102, 80, 14);
        this.damageType.addChoices(new String[]{DAMAGETYPE_GENERIC, DAMAGETYPE_PLAYER});
        this.damageType.setChoiceTooltip(DAMAGETYPE_GENERIC, new String[]{"Generic damage type"});
        this.damageType.setChoiceTooltip(DAMAGETYPE_PLAYER, new String[]{"Damage as done by a player"});
    }

    private void applyCamoToShield() {
        Block block;
        ItemStack stack = ((ShieldTEBase)this.tileEntity).func_70301_a(0);
        int pass = 0;
        if (!stack.func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
            pass = block.func_180664_k().ordinal();
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shield.applyCamo", TypedMap.builder().put(ShieldTEBase.PARAM_PASS, (Object)pass).build());
    }

    private void enableButtons() {
        int sel = this.filterList.getSelected();
        int cnt = this.filterList.getMaximum();
        this.delFilter.setEnabled(sel != -1 && cnt > 0);
        this.upFilter.setEnabled(sel > 0 && cnt > 0);
        this.downFilter.setEnabled(sel < cnt - 1 && sel != -1 && cnt > 0);
        if (sel == -1) {
            this.addFilter.setText("Add");
        } else {
            this.addFilter.setText("Ins");
        }
        this.player.setEnabled("Player".equals(this.typeOptions.getCurrentChoice()));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateFilters();
        this.enableButtons();
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        this.colorSelector.setCurrentColor(Integer.valueOf(((ShieldTEBase)this.tileEntity).getShieldColor()));
        ((ShieldTEBase)this.tileEntity).requestRfFromServer("rftools");
    }
}

