/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.ILevelRenderHelper;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenLevelHelper;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FluidBarClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private ITextRenderHelper labelCache = new ScreenTextHelper();
    private ILevelRenderHelper mbRenderer = new ScreenLevelHelper().gradient(-16742145, -16764109);

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        GlStateManager.func_179140_f();
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            this.mbRenderer.render(xoffset, currenty, screenData, renderInfo);
        } else {
            renderHelper.renderText(xoffset, currenty, 0xFF0000, renderInfo, "<invalid>");
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            int mbcolorNeg = 0xFFFFFF;
            int mbcolor = tagCompound.func_74764_b("mbcolor") ? tagCompound.func_74762_e("mbcolor") : 0xFFFFFF;
            this.mbRenderer.color(mbcolor, mbcolorNeg);
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get(alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            boolean hidebar = tagCompound.func_74767_n("hidebar");
            boolean hidetext = tagCompound.func_74767_n("hidetext");
            boolean showdiff = tagCompound.func_74767_n("showdiff");
            boolean showpct = tagCompound.func_74767_n("showpct");
            this.mbRenderer.settings(hidebar, hidetext, showpct, showdiff);
            this.mbRenderer.format(FormatStyle.values()[tagCompound.func_74762_e("format")]);
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

