/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.font.TrueTypeFont;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ModelScreen;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modulesclient.helper.ClientScreenModuleHelper;
import mcjty.rftools.blocks.screens.network.PacketGetScreenData;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.proxy.ClientProxy;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ScreenRenderer
extends TileEntitySpecialRenderer<ScreenTileEntity> {
    private static final ResourceLocation texture = new ResourceLocation("rftools", "textures/blocks/screenframe.png");
    private final ModelScreen screenModel = new ModelScreen(0);
    private final ModelScreen screenModelLarge = new ModelScreen(1);
    private final ModelScreen screenModelHuge = new ModelScreen(2);
    private ClientScreenModuleHelper clientScreenModuleHelper = new ClientScreenModuleHelper();

    public void render(ScreenTileEntity tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        EnumFacing facing = EnumFacing.SOUTH;
        EnumFacing horizontalFacing = EnumFacing.SOUTH;
        if (tileEntity != null) {
            IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(tileEntity.func_174877_v());
            if (state.func_177230_c() instanceof ScreenBlock) {
                facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
                horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)ScreenBlock.HORIZONTAL_FACING);
            } else {
                return;
            }
        }
        GlStateManager.func_179094_E();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.4375f);
        if (tileEntity == null) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(0, 0);
        } else if (!tileEntity.isTransparent()) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(tileEntity.getSize(), tileEntity.getColor());
        }
        if (tileEntity != null && tileEntity.isRenderable()) {
            FontRenderer fontrenderer = this.func_147498_b();
            IClientScreenModule.TransformMode mode = IClientScreenModule.TransformMode.NONE;
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            Map<Integer, IModuleData> screenData = this.updateScreenData(tileEntity);
            List<IClientScreenModule<?>> modules = tileEntity.getClientScreenModules();
            if (tileEntity.isShowHelp()) {
                modules = ScreenTileEntity.getHelpingScreenModules();
            }
            this.renderModules(fontrenderer, tileEntity, mode, modules, screenData, tileEntity.getSize());
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private Map<Integer, IModuleData> updateScreenData(ScreenTileEntity screenTileEntity) {
        GlobalCoordinate key;
        Map<Integer, IModuleData> screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > (long)ScreenConfiguration.SCREEN_REFRESH_TIMING && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            GlobalCoordinate pos = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().field_73011_w.getDimension());
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetScreenData("rftools", pos, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(key = new GlobalCoordinate(screenTileEntity.func_174877_v(), screenTileEntity.func_145831_w().field_73011_w.getDimension()))) == null) {
            screenData = Collections.emptyMap();
        }
        return screenData;
    }

    private void renderModules(FontRenderer fontrenderer, ScreenTileEntity tileEntity, IClientScreenModule.TransformMode mode, List<IClientScreenModule<?>> modules, Map<Integer, IModuleData> screenData, int size) {
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        BlockPos pos = tileEntity.func_174877_v();
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        IClientScreenModule<?> hitModule = null;
        ScreenTileEntity.ModuleRaytraceResult hit = null;
        IBlockState blockState = this.func_178459_a().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != ScreenSetup.screenBlock && block != ScreenSetup.creativeScreenBlock && block != ScreenSetup.screenHitBlock) {
            return;
        }
        if (mouseOver != null && mouseOver.field_178784_b == blockState.func_177229_b((IProperty)BaseBlock.FACING)) {
            EnumFacing horizontalFacing;
            double zz;
            double yy;
            double xx = mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n();
            hit = tileEntity.getHitModule(xx, yy = mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o(), zz = mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p(), mouseOver.field_178784_b, horizontalFacing = (EnumFacing)blockState.func_177229_b((IProperty)ScreenBlock.HORIZONTAL_FACING));
            if (hit != null) {
                hitModule = modules.get(hit.getModuleIndex());
            }
            tileEntity.focusModuleClient(xx, yy, zz, mouseOver.field_178784_b, horizontalFacing);
        }
        if (tileEntity.isBright()) {
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
        for (IClientScreenModule<?> module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (module.getTransformMode() != mode) {
                    if (mode != IClientScreenModule.TransformMode.NONE) {
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179094_E();
                    mode = module.getTransformMode();
                    switch (mode) {
                        case TEXT: {
                            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.0075f;
                            GlStateManager.func_179152_a((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case TEXTLARGE: {
                            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.015f;
                            GlStateManager.func_179152_a((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case ITEM: {
                            break;
                        }
                    }
                }
                IModuleData data = screenData.get(moduleIndex);
                try {
                    int hitx = -1;
                    int hity = -1;
                    if (module == hitModule) {
                        hitx = hit.getX();
                        hity = hit.getY() - hit.getCurrenty();
                    }
                    TrueTypeFont font = null;
                    switch (tileEntity.getTrueTypeMode()) {
                        case -1: {
                            break;
                        }
                        case 1: {
                            font = ClientProxy.font;
                            break;
                        }
                        case 0: {
                            font = ScreenConfiguration.useTruetype ? ClientProxy.font : null;
                        }
                    }
                    ModuleRenderInfo renderInfo = new ModuleRenderInfo(factor, pos, hitx, hity, font);
                    module.render(this.clientScreenModuleHelper, fontrenderer, currenty, data, renderInfo);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                currenty += height;
            }
            ++moduleIndex;
        }
        if (tileEntity.isBright()) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
        if (mode != IClientScreenModule.TransformMode.NONE) {
            GlStateManager.func_179121_F();
        }
    }

    private void renderScreenBoard(int size, int color) {
        this.func_147499_a(texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (size == 2) {
            this.screenModelHuge.render();
        } else if (size == 1) {
            this.screenModelLarge.render();
        } else {
            this.screenModel.render();
        }
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float dim = size == 2 ? 2.46f : (size == 1 ? 1.46f : 0.46f);
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        renderer.func_181662_b((double)-0.46f, (double)dim, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, (double)-0.08f).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

