/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.Optional;
import java.util.function.Function;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.varia.Logging;
import mcjty.rftools.Achievements;
import mcjty.rftools.ClientInfo;
import mcjty.rftools.api.screens.IScreenModuleRegistry;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftools.apiimpl.ScreenModuleRegistry;
import mcjty.rftools.apiimpl.TeleportationManager;
import mcjty.rftools.commands.CommandRftCfg;
import mcjty.rftools.commands.CommandRftDb;
import mcjty.rftools.commands.CommandRftShape;
import mcjty.rftools.commands.CommandRftTp;
import mcjty.rftools.integration.computers.OpenComputersIntegration;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.manual.GuiRFToolsManual;
import mcjty.rftools.proxy.CommonProxy;
import mcjty.rftools.wheelsupport.WheelSupport;
import mcjty.rftools.xnet.XNetSupport;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="rftools", name="RFTools", dependencies="required-after:mcjtylib_ng@[3.0.5,);before:xnet@[1.7.0,);after:forge@[14.22.0.2464,)", acceptedMinecraftVersions="[1.12,1.13)", version="7.59")
public class RFTools
implements ModBase {
    public static final String MODID = "rftools";
    public static final String VERSION = "7.59";
    public static final String MIN_FORGE_VER = "14.22.0.2464";
    public static final String MIN_MCJTYLIB_VER = "3.0.5";
    public static final String MIN_XNET_VER = "1.7.0";
    @SidedProxy(clientSide="mcjty.rftools.proxy.ClientProxy", serverSide="mcjty.rftools.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="rftools")
    public static RFTools instance;
    public boolean rftoolsDimensions = false;
    public boolean xnet = false;
    public static ScreenModuleRegistry screenModuleRegistry;
    private static int modGuiIndex;
    public ClientInfo clientInfo = new ClientInfo();
    public static CreativeTabs tabRfTools;
    public static final String SHIFT_MESSAGE = "<Press Shift>";
    public static final int GUI_MANUAL_MAIN;
    public static final int GUI_MANUAL_SHAPE;
    public static final int GUI_COALGENERATOR;
    public static final int GUI_CRAFTER;
    public static final int GUI_MODULAR_STORAGE;
    public static final int GUI_REMOTE_STORAGE;
    public static final int GUI_STORAGE_FILTER;
    public static final int GUI_MODIFIER_MODULE;
    public static final int GUI_REMOTE_STORAGE_ITEM;
    public static final int GUI_MODULAR_STORAGE_ITEM;
    public static final int GUI_REMOTE_STORAGESCANNER_ITEM;
    public static final int GUI_DIALING_DEVICE;
    public static final int GUI_MATTER_RECEIVER;
    public static final int GUI_MATTER_TRANSMITTER;
    public static final int GUI_ADVANCEDPORTER;
    public static final int GUI_TELEPORTPROBE;
    public static final int GUI_SCREEN;
    public static final int GUI_SCREENCONTROLLER;
    public static final int GUI_COUNTER;
    public static final int GUI_SEQUENCER;
    public static final int GUI_TIMER;
    public static final int GUI_THREE_LOGIC;
    public static final int GUI_ANALOG;
    public static final int GUI_MACHINE_INFUSER;
    public static final int GUI_BUILDER;
    public static final int GUI_SHAPECARD;
    public static final int GUI_SHAPECARD_COMPOSER;
    public static final int GUI_CHAMBER_DETAILS;
    public static final int GUI_POWERCELL;
    public static final int GUI_RELAY;
    public static final int GUI_LIQUID_MONITOR;
    public static final int GUI_RF_MONITOR;
    public static final int GUI_SHIELD;
    public static final int GUI_ENVIRONMENTAL_CONTROLLER;
    public static final int GUI_MATTER_BEAMER;
    public static final int GUI_SPAWNER;
    public static final int GUI_BLOCK_PROTECTOR;
    public static final int GUI_ITEMFILTER;
    public static final int GUI_SECURITY_MANAGER;
    public static final int GUI_DEVELOPERS_DELIGHT;
    public static final int GUI_LIST_BLOCKS;
    public static final int GUI_ENDERGENIC;
    public static final int GUI_PEARL_INJECTOR;
    public static final int GUI_ENDERMONITOR;
    public static final int GUI_STORAGE_SCANNER;
    public static final int GUI_BOOSTER;
    public static final int GUI_INVCHECKER;
    public static final int GUI_SENSOR;
    public static final int GUI_STORAGE_TERMINAL;
    public static final int GUI_STORAGE_TERMINAL_SCANNER;
    public static final int GUI_ELEVATOR;
    public static final int GUI_COMPOSER;
    public static final int GUI_SCANNER;
    public static final int GUI_PROJECTOR;
    public static final int GUI_LOCATOR;
    public static final int GUI_REDSTONE_RECEIVER;

    public String getModId() {
        return MODID;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        WheelSupport.registerWheel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        Achievements.init();
        if (Loader.isModLoaded((String)"rftoolsdim")) {
            this.rftoolsDimensions = true;
            Logging.log((String)"RFTools Detected Dimensions addon: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftoolsdim", (String)"getDimensionManager", (String)"mcjty.rftools.apideps.RFToolsDimensionChecker$GetDimensionManager");
        }
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mcjty.rftools.theoneprobe.TheOneProbeSupport");
        if (Loader.isModLoaded((String)"xnet")) {
            this.xnet = true;
            Logging.log((String)"RFTools Detected XNet: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"xnet", (String)"getXNet", (String)XNetSupport.GetXNet.class.getName());
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            OpenComputersIntegration.init();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftTp());
        event.registerServerCommand((ICommand)new CommandRftShape());
        event.registerServerCommand((ICommand)new CommandRftDb());
        event.registerServerCommand((ICommand)new CommandRftCfg());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            Optional value;
            if (message.key.equalsIgnoreCase("getApi") || message.key.equalsIgnoreCase("getTeleportationManager")) {
                value = message.getFunctionValue(ITeleportationManager.class, Void.class);
                ((Function)value.get()).apply(new TeleportationManager());
                continue;
            }
            if (!message.key.equalsIgnoreCase("getScreenModuleRegistry")) continue;
            value = message.getFunctionValue(IScreenModuleRegistry.class, Void.class);
            ((Function)value.get()).apply(screenModuleRegistry);
        }
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiRFToolsManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        screenModuleRegistry = new ScreenModuleRegistry();
        modGuiIndex = 0;
        tabRfTools = new CreativeTabs("RfTools"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModItems.rfToolsManualItem);
            }
        };
        GUI_MANUAL_MAIN = modGuiIndex++;
        GUI_MANUAL_SHAPE = modGuiIndex++;
        GUI_COALGENERATOR = modGuiIndex++;
        GUI_CRAFTER = modGuiIndex++;
        GUI_MODULAR_STORAGE = modGuiIndex++;
        GUI_REMOTE_STORAGE = modGuiIndex++;
        GUI_STORAGE_FILTER = modGuiIndex++;
        GUI_MODIFIER_MODULE = modGuiIndex++;
        GUI_REMOTE_STORAGE_ITEM = modGuiIndex++;
        GUI_MODULAR_STORAGE_ITEM = modGuiIndex++;
        GUI_REMOTE_STORAGESCANNER_ITEM = modGuiIndex++;
        GUI_DIALING_DEVICE = modGuiIndex++;
        GUI_MATTER_RECEIVER = modGuiIndex++;
        GUI_MATTER_TRANSMITTER = modGuiIndex++;
        GUI_ADVANCEDPORTER = modGuiIndex++;
        GUI_TELEPORTPROBE = modGuiIndex++;
        GUI_SCREEN = modGuiIndex++;
        GUI_SCREENCONTROLLER = modGuiIndex++;
        GUI_COUNTER = modGuiIndex++;
        GUI_SEQUENCER = modGuiIndex++;
        GUI_TIMER = modGuiIndex++;
        GUI_THREE_LOGIC = modGuiIndex++;
        GUI_ANALOG = modGuiIndex++;
        GUI_MACHINE_INFUSER = modGuiIndex++;
        GUI_BUILDER = modGuiIndex++;
        GUI_SHAPECARD = modGuiIndex++;
        GUI_SHAPECARD_COMPOSER = modGuiIndex++;
        GUI_CHAMBER_DETAILS = modGuiIndex++;
        GUI_POWERCELL = modGuiIndex++;
        GUI_RELAY = modGuiIndex++;
        GUI_LIQUID_MONITOR = modGuiIndex++;
        GUI_RF_MONITOR = modGuiIndex++;
        GUI_SHIELD = modGuiIndex++;
        GUI_ENVIRONMENTAL_CONTROLLER = modGuiIndex++;
        GUI_MATTER_BEAMER = modGuiIndex++;
        GUI_SPAWNER = modGuiIndex++;
        GUI_BLOCK_PROTECTOR = modGuiIndex++;
        GUI_ITEMFILTER = modGuiIndex++;
        GUI_SECURITY_MANAGER = modGuiIndex++;
        GUI_DEVELOPERS_DELIGHT = modGuiIndex++;
        GUI_LIST_BLOCKS = modGuiIndex++;
        GUI_ENDERGENIC = modGuiIndex++;
        GUI_PEARL_INJECTOR = modGuiIndex++;
        GUI_ENDERMONITOR = modGuiIndex++;
        GUI_STORAGE_SCANNER = modGuiIndex++;
        GUI_BOOSTER = modGuiIndex++;
        GUI_INVCHECKER = modGuiIndex++;
        GUI_SENSOR = modGuiIndex++;
        GUI_STORAGE_TERMINAL = modGuiIndex++;
        GUI_STORAGE_TERMINAL_SCANNER = modGuiIndex++;
        GUI_ELEVATOR = modGuiIndex++;
        GUI_COMPOSER = modGuiIndex++;
        GUI_SCANNER = modGuiIndex++;
        GUI_PROJECTOR = modGuiIndex++;
        GUI_LOCATOR = modGuiIndex++;
        GUI_REDSTONE_RECEIVER = modGuiIndex++;
    }
}

