/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import p455w0rdslib.api.gui.IGuiElement;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiPos;

public abstract class GuiElement
implements IGuiElement {
    protected static final ResourceLocation VANILLA_BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    private IModularGui gui;
    private GuiPos pos;
    private int w;
    private int h;
    private boolean enabled = true;
    private boolean visible = true;
    private List<String> tooltip = Lists.newArrayList();

    public GuiElement(IModularGui gui, GuiPos posIn) {
        this.gui = gui;
        this.pos = posIn;
    }

    public GuiElement(IModularGui gui, GuiPos posIn, int width, int height) {
        this.gui = gui;
        this.pos = posIn;
        this.w = width;
        this.h = height;
    }

    @Override
    public abstract void drawBackground(int var1, int var2, float var3);

    @Override
    public abstract void drawForeground(int var1, int var2);

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public boolean onRightClick(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public boolean onMiddleClick(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int button) {
        switch (button) {
            default: {
                return this.onClick(mouseX, mouseY);
            }
            case 1: {
                return this.onRightClick(mouseX, mouseY);
            }
            case 2: 
        }
        return this.onMiddleClick(mouseX, mouseY);
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY, int button) {
    }

    @Override
    public IModularGui getGui() {
        return this.gui;
    }

    @Override
    public IGuiElement setGui(IModularGui guiIn) {
        this.gui = guiIn;
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public IGuiElement setVisible(boolean visibility) {
        this.visible = visibility;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGuiElement setEnabled(boolean doEnable) {
        this.enabled = doEnable;
        return this;
    }

    @Override
    public IGuiElement enable() {
        return this.setEnabled(true);
    }

    @Override
    public IGuiElement disable() {
        return this.setEnabled(false);
    }

    @Override
    public GuiPos getPos() {
        return this.pos;
    }

    @Override
    public IGuiElement setPos(int xPos, int yPos) {
        this.pos = new GuiPos(xPos, yPos);
        return this;
    }

    @Override
    public int getX() {
        return this.pos.getX();
    }

    @Override
    public IGuiElement setX(int posX) {
        this.setPos(posX, this.getY());
        return this;
    }

    @Override
    public int getY() {
        return this.pos.getY();
    }

    @Override
    public IGuiElement setY(int posY) {
        this.setPos(this.getX(), posY);
        return this;
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    @Override
    public IGuiElement setWidth(int width) {
        this.w = width;
        return this;
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    @Override
    public IGuiElement setHeight(int height) {
        this.h = height;
        return this;
    }

    @Override
    public IGuiElement setSize(int width, int height) {
        this.w = width;
        this.h = height;
        return this;
    }

    @Override
    public void update(int mouseX, int mouseY) {
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        return false;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    @Override
    public IGuiElement setTooltip(List<String> tooltipLines) {
        this.tooltip = tooltipLines;
        return this;
    }

    @Override
    public boolean hasTooltip() {
        return this.getTooltip().size() > 0;
    }
}

