/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.IPowerProvider;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockDevice;
import erogenousbeef.bigreactors.common.multiblock.block.PowerTapState;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapTesla;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapTesla;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.crafting.RecipeHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockMultiblockPowerTap
extends BlockMultiblockDevice {
    private PowerSystem _powerSystem;

    public BlockMultiblockPowerTap(PartType type, String blockName, PowerSystem powerSystem) {
        super(type, blockName);
        this._powerSystem = powerSystem;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        boolean isRF = PowerSystem.RedstoneFlux == this._powerSystem;
        switch (this._type) {
            case ReactorPowerTap: {
                return isRF ? new TileEntityReactorPowerTapRedstoneFlux() : new TileEntityReactorPowerTapTesla();
            }
            case TurbinePowerPort: {
                return isRF ? new TileEntityTurbinePowerTapRedstoneFlux() : new TileEntityTurbinePowerTapTesla();
            }
        }
        throw new IllegalArgumentException("Invalid part type");
    }

    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
        if (PartType.ReactorPowerTap == this._type) {
            if (!BigReactors.CONFIG.enableReactorPowerTapRecipe) {
                return;
            }
            if (PowerSystem.RedstoneFlux == this._powerSystem) {
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"CRC", "R R", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), Items.field_151137_ax});
                }
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"CRC", "R R", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), Items.field_151137_ax});
                }
            } else if (PowerSystem.Tesla == this._powerSystem) {
                ItemStack lapis = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b());
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"CRC", "R R", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), lapis});
                }
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"CRC", "R R", "CRC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), lapis});
                }
            }
        } else if (PartType.TurbinePowerPort == this._type) {
            if (PowerSystem.RedstoneFlux == this._powerSystem) {
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"HRH", "R R", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), Items.field_151137_ax});
                }
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"HRH", "R R", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), Items.field_151137_ax});
                }
            } else if (PowerSystem.Tesla == this._powerSystem) {
                ItemStack lapis = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b());
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"HRH", "R R", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), lapis});
                }
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
                    RecipeHelper.addShapedRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"HRH", "R R", "HRH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), lapis});
                }
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, position, neighbor);
        }
    }

    public void func_189540_a(IBlockState stateAtPosition, World world, BlockPos position, Block neighbor, BlockPos neighborPos) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, position, stateAtPosition, neighbor);
        }
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.POWERTAPSTATE});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.POWERTAPSTATE, (Comparable)((Object)PowerTapState.Disconnected));
    }

    @Override
    protected IBlockState buildActualState(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part) {
        boolean connected = part instanceof IPowerProvider && ((IPowerProvider)part).isProviderConnected();
        return super.buildActualState(state, world, position, part).func_177226_a(Properties.POWERTAPSTATE, (Comparable)((Object)(connected ? PowerTapState.Connected : PowerTapState.Disconnected)));
    }
}

