/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleFlowerRemover
extends ModuleBase {
    private int tick;
    private float bladeangle;
    private float bladespeed = 0.0f;

    public ModuleFlowerRemover(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().field_70170_p.field_72995_K) {
            this.bladeangle += this.getBladeSpindSpeed();
            this.bladespeed = this.getCart().hasFuel() ? Math.min(1.0f, this.bladespeed + 0.005f) : Math.max(0.0f, this.bladespeed - 0.005f);
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.mownTheLawn();
                this.shearEntities();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void mownTheLawn() {
        BlockPos cartPos = this.getCart().func_180425_c();
        for (int x = -this.getBlocksOnSide(); x <= this.getBlocksOnSide(); ++x) {
            for (int z = -this.getBlocksOnSide(); z <= this.getBlocksOnSide(); ++z) {
                for (int y = -this.getBlocksFromLevel(); y <= this.getBlocksFromLevel(); ++y) {
                    IBlockState state;
                    BlockPos pos = cartPos.func_177982_a(x, y, z);
                    if (!this.isFlower(pos) || (state = this.getCart().field_70170_p.func_180495_p(pos)) == null) continue;
                    this.addStuff(state.func_177230_c().getDrops((IBlockAccess)this.getCart().field_70170_p, pos, state, 0));
                    this.getCart().field_70170_p.func_175698_g(pos);
                }
            }
        }
    }

    private void shearEntities() {
        List entities = this.getCart().field_70170_p.func_72872_a(EntityLiving.class, this.getCart().func_174813_aQ().func_72314_b((double)this.getBlocksOnSide(), (double)((float)this.getBlocksFromLevel() + 2.0f), (double)this.getBlocksOnSide()));
        for (EntityLiving target : entities) {
            BlockPos pos;
            IShearable shearable;
            if (!(target instanceof IShearable) || !(shearable = (IShearable)target).isShearable(ItemStack.field_190927_a, (IBlockAccess)this.getCart().field_70170_p, pos = target.func_180425_c())) continue;
            this.addStuff(shearable.onSheared(ItemStack.field_190927_a, (IBlockAccess)this.getCart().field_70170_p, pos, 0));
        }
    }

    private boolean isFlower(BlockPos pos) {
        IBlockState state = this.getCart().field_70170_p.func_180495_p(pos);
        return state != null && state.func_177230_c() instanceof IPlantable;
    }

    private void addStuff(List<ItemStack> stuff) {
        for (ItemStack iStack : stuff) {
            this.getCart().addItemToChest(iStack);
            if (iStack.func_190916_E() == 0) continue;
            EntityItem entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = 0.0;
            this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    public float getBladeAngle() {
        return this.bladeangle;
    }

    public float getBladeSpindSpeed() {
        return this.bladespeed;
    }
}

