/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonAssembly;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.modules.workers.ModuleComputer;

public class ButtonVarType
extends ButtonAssembly {
    private int typeId;

    public ButtonVarType(ModuleComputer module, ButtonBase.LOCATION loc, int id) {
        super(module, loc);
        this.typeId = id;
    }

    @Override
    public String toString() {
        return "Change to " + ComputerTask.getVarTypeName(this.typeId);
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        if (this.module instanceof ModuleComputer && ((ModuleComputer)this.module).getSelectedTasks() != null && ((ModuleComputer)this.module).getSelectedTasks().size() > 0) {
            for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
                if (ComputerTask.isVar(task.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int texture() {
        return ComputerTask.getVarImage(this.typeId);
    }

    @Override
    public int ColorCode() {
        return 2;
    }

    @Override
    public boolean isEnabled() {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            if (task.getVarType() == this.typeId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            task.setVarType(this.typeId);
        }
    }
}

