/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.modules.data.ModuleData;

@Mod.EventBusSubscriber(modid="stevescarts")
public class SCConfig {
    public static final SCConfig INSTANCE = new SCConfig();
    public static boolean disableTimedCrafting = false;
    public static int maxDynamites = 50;
    public static boolean useArcadeSounds = true;
    public static boolean useArcadeMobSounds = true;
    public static int drillSize = 4;
    public static boolean enableEaster = true;
    public static boolean enableHalloween = true;
    public static boolean enableChristmas = true;
    private static Multimap<String, String> ironTierRepair;
    private static Multimap<String, String> diamondTierRepair;
    private static Multimap<String, String> hardenedTierRepair;
    public static String ironRepairName;
    public static String diamondRepairName;
    public static String hardenedRepairName;
    public static HashMap<Byte, Boolean> validModules;
    public Configuration config;

    public void load(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.sync();
    }

    public void save() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void sync() {
        for (ModuleData module : ModuleData.getList().values()) {
            if (module.getIsLocked()) continue;
            String name = module.getName().replace(" ", "").replace(":", "_");
            validModules.put(module.getID(), this.config.get("EnabledModules", name, module.getEnabledByDefault()).setRequiresMcRestart(true).getBoolean(true));
        }
        disableTimedCrafting = this.config.getBoolean("DisableCartAssemberTime", "Settings", false, "Set to true to disable the timer in the cart assember, it will still require fuel");
        maxDynamites = this.config.getInt("MaximumNumberOfDynamites", "Settings", 50, 0, maxDynamites, "The max amount of dynamite you can put into a dynamite carrier");
        useArcadeSounds = this.config.getBoolean("useArcadeSounds", "Settings", true, "If the sounds in the arcade should be enabled");
        useArcadeMobSounds = this.config.getBoolean("useTetrisMobSounds", "Settings", true, "If mob sounds should be used in the tetris arcade game");
        drillSize = this.config.getInt("maxDrillWidth", "Settings", 4, 1, 4, "The max width beside the cart that the drills can mine, the drill diameter will be (width * 2 + 1)\nMin: 1\nMax: 4");
        String[] ironRepair = this.config.getStringList("Iron Tier Repair Items", "Repair", new String[]{"minecraft:iron_ingot"}, "A list of items that can repair an iron tier tool");
        String[] diamondRepair = this.config.getStringList("Diamond Tier Repair Items", "Repair", new String[]{"ore:gemDiamond"}, "A list of items that can repair an diamond tier tool");
        String[] hardenedRepair = this.config.getStringList("Hardened Tier Repair Items", "Repair", new String[]{"stevescarts:modulecomponents:22"}, "A list of items that can repair an hardened tier tool");
        ironTierRepair = HashMultimap.create();
        SCConfig.parseRepairMaterial(ironRepair, (Multimap<String, String>)ironTierRepair, "iron");
        diamondTierRepair = HashMultimap.create();
        SCConfig.parseRepairMaterial(diamondRepair, (Multimap<String, String>)diamondTierRepair, "diamond");
        hardenedTierRepair = HashMultimap.create();
        SCConfig.parseRepairMaterial(hardenedRepair, (Multimap<String, String>)hardenedTierRepair, "hardened");
        ironRepairName = this.config.getString("Iron Tier Name", "Repair", "", "Set name of what is needed to repair iron tier tool, blank uses default text");
        diamondRepairName = this.config.getString("Diamond Tier Name", "Repair", "", "Set name of what is needed to repair diamond tier tool, blank uses default text");
        hardenedRepairName = this.config.getString("Hardened Tier Name", "Repair", "", "Set name of what is needed to repair hardened tier tool, blank uses default text");
        this.config.setCategoryComment("Events", "Whether to let the events happen during their time frames of not");
        enableEaster = this.config.getBoolean("Enable Easter", "Events", true, "If the easter event can occur");
        enableHalloween = this.config.getBoolean("Enable Halloween", "Events", true, "If the halloween event can occur");
        enableChristmas = this.config.getBoolean("Enable Christmas", "Events", true, "If the christmas event can occur");
        this.save();
    }

    private static void parseRepairMaterial(String[] repairItem, Multimap<String, String> map, String type) {
        for (String whitelisted : repairItem) {
            try {
                String[] data = whitelisted.split(":");
                String item = data[0] + ":" + data[1];
                String meta = null;
                if (data.length <= 2) {
                    meta = "0";
                } else {
                    try {
                        meta = String.valueOf(Integer.parseInt(data[2]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if ("*".equals(data[2])) {
                        meta = data[2];
                    }
                }
                if (meta == null) {
                    StevesCarts.logger.error("Failed to parse " + type + " repair item: " + whitelisted + ". Invalid metadata: " + data[2]);
                    continue;
                }
                map.put((Object)item, (Object)meta);
            }
            catch (Exception e) {
                StevesCarts.logger.error("Failed to parse " + type + " repair item: " + whitelisted);
            }
        }
    }

    public static boolean isValidRepairItem(ItemStack stack, String type) {
        Multimap<String, String> map;
        Multimap<String, String> multimap = "iron".equals(type) ? ironTierRepair : (map = "diamond".equals(type) ? diamondTierRepair : hardenedTierRepair);
        if (stack.func_190926_b()) {
            return false;
        }
        String stackMeta = String.valueOf(stack.func_77960_j());
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        Collection metas = map.get((Object)name.toString());
        for (String meta : metas) {
            if ("*".equals(meta)) {
                return true;
            }
            if (!meta.equals(stackMeta)) continue;
            return true;
        }
        for (Object id : (Object)OreDictionary.getOreIDs((ItemStack)stack)) {
            String ore = "ore:" + OreDictionary.getOreName((int)id);
            if (map.get((Object)ore).size() <= 0) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("stevescarts")) {
            this.sync();
        }
    }

    static {
        validModules = new HashMap();
    }
}

