/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.steam;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoSteam;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.steam.SteamFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.SteamManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

public class SteamFuelCategory
extends BaseFuelCategory<SteamFuelWrapper> {
    public static boolean enable = true;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Dynamo.Steam", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SteamFuelCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(SteamFuelCategory.getRecipes(registry, guiHelper), "thermalexpansion.steam");
        registry.addRecipeClickArea(GuiDynamoSteam.class, 115, 35, 16, 16, new String[]{"thermalexpansion.steam"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoSteam, new String[]{"thermalexpansion.steam"});
    }

    public static List<SteamFuelWrapper> getRecipes(IModRegistry registry, IGuiHelper guiHelper) {
        ArrayList<SteamFuelWrapper> recipes = new ArrayList<SteamFuelWrapper>();
        for (ComparableItemStack fuel : SteamManager.getFuels()) {
            ItemStack fuelStack = fuel.toItemStack();
            recipes.add(new SteamFuelWrapper(guiHelper, fuelStack, SteamManager.getFuelEnergy(fuelStack)));
        }
        Set<ComparableItemStack> specificFuels = SteamManager.getFuels();
        for (ItemStack fuel : registry.getIngredientRegistry().getFuels()) {
            int energy;
            if (specificFuels.contains(new ComparableItemStack(fuel)) || (energy = SteamManager.getFuelEnergy(fuel)) <= 0) continue;
            recipes.add(new SteamFuelWrapper(guiHelper, fuel, energy));
        }
        return recipes;
    }

    public SteamFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoSteam.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(4);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.steam.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.steam";
    }

    public void setRecipe(IRecipeLayout recipeLayout, SteamFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
    }
}

