/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiInsolator;
import cofh.thermalexpansion.gui.container.machine.ContainerInsolator;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileInsolator
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.INSOLATOR.getMetadata();
    public static int basePower = 20;
    public static final int MONOCULTURE_ENERGY_MOD = 50;
    private InsolatorManager.InsolatorRecipe curRecipe;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    public boolean lockPrimary = true;
    private FluidTankCore tank = new FluidTankCore(10000);
    protected boolean augmentTree;
    protected boolean augmentMonoculture;

    public static void initialize() {
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE] = new SideConfig();
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].numConfig = 9;
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileInsolator.ALT_SIDE_CONFIGS[TileInsolator.TYPE] = new SideConfig();
        TileInsolator.ALT_SIDE_CONFIGS[TileInsolator.TYPE].numConfig = 2;
        TileInsolator.ALT_SIDE_CONFIGS[TileInsolator.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        TileInsolator.ALT_SIDE_CONFIGS[TileInsolator.TYPE].sideTypes = new int[]{0, 7};
        TileInsolator.ALT_SIDE_CONFIGS[TileInsolator.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE] = new SlotConfig();
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false};
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE].allowExtractionSlot = new boolean[]{false, false, true, true, false};
        TileInsolator.VALID_AUGMENTS[TileInsolator.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineInsolatorFertilizer");
        VALID_AUGMENTS[TYPE].add("machineInsolatorMonoculture");
        VALID_AUGMENTS[TYPE].add("machineInsolatorTree");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileInsolator.LIGHT_VALUES[TileInsolator.TYPE] = 14;
        GameRegistry.registerTileEntity(TileInsolator.class, (String)"thermalexpansion:machine_insolator");
        TileInsolator.config();
    }

    public static void config() {
        String category = "Machine.Insolator";
        BlockMachine.enable[TileInsolator.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Phytogenic Insolator. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileInsolator.ENERGY_CONFIGS[TileInsolator.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileInsolator() {
        this.inventory = new ItemStack[5];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.inventory[1].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.tank.getFluidAmount() < this.curRecipe.getWater()) {
            return false;
        }
        if (this.curRecipe.getType() == InsolatorManager.Type.TREE && !this.augmentTree) {
            return false;
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? this.curRecipe.getPrimaryInput().func_190916_E() > this.inventory[1].func_190916_E() || this.curRecipe.getSecondaryInput().func_190916_E() > this.inventory[0].func_190916_E() : this.curRecipe.getPrimaryInput().func_190916_E() > this.inventory[0].func_190916_E() || this.curRecipe.getSecondaryInput().func_190916_E() > this.inventory[1].func_190916_E()) {
            return false;
        }
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        if (!(secondaryItem.func_190926_b() || this.inventory[3].func_190926_b() || this.augmentSecondaryNull)) {
            if (!this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[3].func_190916_E() + secondaryItem.func_190916_E() > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[2].func_190926_b() || this.inventory[2].func_77969_a(primaryItem) && this.inventory[2].func_190916_E() + primaryItem.func_190916_E() <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            return this.curRecipe.getPrimaryInput().func_190916_E() <= this.inventory[1].func_190916_E() && this.curRecipe.getSecondaryInput().func_190916_E() <= this.inventory[0].func_190916_E();
        }
        return this.curRecipe.getPrimaryInput().func_190916_E() <= this.inventory[0].func_190916_E() && this.curRecipe.getSecondaryInput().func_190916_E() <= this.inventory[1].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = InsolatorManager.getRecipe(this.inventory[1], this.inventory[0]);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        this.tank.modifyFluidStored(-this.curRecipe.getWater());
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        boolean hasFertilizer = this.curRecipe.hasFertilizer();
        if (hasFertilizer) {
            ItemStack input = this.curRecipe.getPrimaryInput();
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
            } else {
                this.inventory[2].func_190917_f(primaryItem.func_190916_E());
            }
            if (!secondaryItem.func_190926_b()) {
                int modifiedChance = this.secondaryChance;
                int recipeChance = this.curRecipe.getSecondaryOutputChance();
                if (this.augmentMonoculture && secondaryItem.func_77969_a(input)) {
                    recipeChance -= 100;
                }
                if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                    if (this.inventory[3].func_190926_b()) {
                        this.inventory[3] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                    } else if (this.inventory[3].func_77969_a(secondaryItem)) {
                        this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                    }
                    if (this.inventory[3].func_190916_E() > this.inventory[3].func_77976_d()) {
                        this.inventory[3].func_190920_e(this.inventory[3].func_77976_d());
                    }
                }
            }
            int countInput = this.augmentMonoculture ? 0 : this.curRecipe.getPrimaryInput().func_190916_E();
            int countFertilizer = this.curRecipe.getSecondaryInput().func_190916_E();
            if (this.reuseChance > 0) {
                if (InsolatorManager.isItemFertilizer(this.inventory[0])) {
                    if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                        this.inventory[0].func_190918_g(countFertilizer);
                    }
                    this.inventory[1].func_190918_g(countInput);
                } else {
                    if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                        this.inventory[1].func_190918_g(countFertilizer);
                    }
                    this.inventory[0].func_190918_g(countInput);
                }
            } else if (InsolatorManager.isItemFertilizer(this.inventory[0])) {
                this.inventory[0].func_190918_g(countFertilizer);
                this.inventory[1].func_190918_g(countInput);
            } else {
                this.inventory[1].func_190918_g(countFertilizer);
                this.inventory[0].func_190918_g(countInput);
            }
        } else {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
            } else {
                this.inventory[2].func_190917_f(primaryItem.func_190916_E());
            }
            if (!secondaryItem.func_190926_b()) {
                int modifiedChance = this.secondaryChance;
                int recipeChance = this.curRecipe.getSecondaryOutputChance();
                if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                    if (this.inventory[3].func_190926_b()) {
                        this.inventory[3] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                        if (this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                            this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                        }
                    } else if (this.inventory[3].func_77969_a(secondaryItem)) {
                        this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                        if (this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                            this.inventory[3].func_190917_f(secondaryItem.func_190916_E());
                        }
                    }
                    if (this.inventory[3].func_190916_E() > this.inventory[3].func_77976_d()) {
                        this.inventory[3].func_190920_e(this.inventory[3].func_77976_d());
                    }
                }
            }
            int count1 = this.curRecipe.getPrimaryInput().func_190916_E();
            int count2 = this.curRecipe.getSecondaryInput().func_190916_E();
            if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
                this.inventory[1].func_190918_g(count1);
                this.inventory[0].func_190918_g(count2);
            } else {
                this.inventory[0].func_190918_g(count1);
                this.inventory[1].func_190918_g(count2);
            }
        }
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
        if (this.inventory[1].func_190916_E() <= 0) {
            this.inventory[1] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.getTransferIn()) {
            return;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerPrimary = side;
            break;
        }
        for (i = this.inputTrackerSecondary + 1; i <= this.inputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isSecondaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.getTransferOut()) {
            return;
        }
        if (!this.inventory[2].func_190926_b()) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[3].func_190926_b()) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(3, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiInsolator(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerInsolator(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTrackerPrimary = nbt.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nbt.func_74762_e("Tracker2");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nbt.func_74768_a("Tracker2", this.outputTrackerSecondary);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        this.callNeighborTileChange();
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentTree = false;
        this.augmentMonoculture = false;
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentMonoculture && "machineInsolatorMonoculture".equals(id)) {
            return false;
        }
        if (this.augmentTree && "machineInsolatorTree".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machineInsolatorFertilizer".equals(id)) {
            this.reuseChance += 20;
            this.energyMod += 15;
        }
        if (!this.augmentMonoculture && "machineInsolatorMonoculture".equals(id)) {
            this.augmentMonoculture = true;
            this.hasModeAugment = true;
            this.reuseChance += 10;
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentTree && "machineInsolatorTree".equals(id)) {
            this.augmentTree = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.lockPrimary) {
            if (slot == 0) {
                return InsolatorManager.isItemFertilizer(stack);
            }
            if (slot == 1) {
                return !InsolatorManager.isItemFertilizer(stack) && InsolatorManager.isItemValid(stack);
            }
        }
        return slot > 1 || InsolatorManager.isItemValid(stack);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileInsolator.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileInsolator.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileInsolator.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileInsolator)TileInsolator.this).sideConfig.sideTypes[TileInsolator.this.sideCache[from.ordinal()]])) {
                        return TileInsolator.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileInsolator.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileInsolator)TileInsolator.this).sideConfig.sideTypes[TileInsolator.this.sideCache[from.ordinal()]])) {
                        return TileInsolator.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

