/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class BlockData {
    public static boolean parseBlockList(ConfigValue blockEntry, List<WeightedBlock> list, boolean wildcard) {
        if (blockEntry == null) {
            return false;
        }
        if (blockEntry.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)blockEntry;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedBlock entry = BlockData.parseBlockEntry((ConfigValue)blockList.get(i), wildcard);
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            if (blockEntry.valueType() == ConfigValueType.NULL) {
                return true;
            }
            WeightedBlock entry = BlockData.parseBlockEntry(blockEntry, wildcard);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedBlock parseBlockEntry(ConfigValue blockEntry, boolean wildcard) {
        int min = wildcard ? 0 : -1;
        switch (blockEntry.valueType()) {
            case NULL: {
                CoFHWorld.log.warn("Null Block entry on line {}!", (Object)blockEntry.origin().lineNumber());
                return null;
            }
            case OBJECT: {
                Config blockObject = ((ConfigObject)blockEntry).toConfig();
                if (!blockObject.hasPath("name")) {
                    CoFHWorld.log.error("Block entry needs a name!");
                    return null;
                }
                String blockName = blockObject.getString("name");
                Block block = BlockData.parseBlock(blockName);
                if (block == null) {
                    CoFHWorld.log.error("Invalid block name on line {}!", (Object)blockObject.getValue("name").origin().lineNumber());
                    return null;
                }
                int weight = blockObject.hasPath("weight") ? MathHelper.func_76125_a((int)blockObject.getInt("weight"), (int)1, (int)1000000) : 100;
                NBTTagCompound dataTag = null;
                if (blockObject.hasPath("data-tag")) {
                    try {
                        dataTag = JsonToNBT.func_180713_a((String)blockObject.getString("data-tag"));
                    }
                    catch (NBTException e) {
                        CoFHWorld.log.error("Invalid NBT data defined on line {}.", (Object)blockObject.getValue("data-tag").origin().lineNumber());
                        CoFHWorld.log.catching(Level.DEBUG, (Throwable)e);
                    }
                }
                if (blockObject.hasPath("properties")) {
                    BlockStateContainer blockstatecontainer = block.func_176194_O();
                    IBlockState state = block.func_176223_P();
                    for (Map.Entry propEntry : blockObject.getObject("properties").entrySet()) {
                        IProperty prop = blockstatecontainer.func_185920_a((String)propEntry.getKey());
                        if (prop == null) {
                            CoFHWorld.log.warn("Block '{}' does not have property '{}'.", (Object)blockName, propEntry.getKey());
                        }
                        if (((ConfigValue)propEntry.getValue()).valueType() != ConfigValueType.STRING) {
                            CoFHWorld.log.error("Property '{}' is not a string. All block properties must be strings.", propEntry.getKey());
                            prop = null;
                        }
                        if (prop == null || (state = BlockData.setValue(state, prop, (String)((ConfigValue)propEntry.getValue()).unwrapped())) != null) continue;
                        return null;
                    }
                    return new WeightedBlock(state, dataTag, weight);
                }
                ConfigValue data = null;
                if (blockObject.hasPath("data")) {
                    data = blockObject.getValue("data");
                } else if (blockObject.hasPath("metadata")) {
                    data = blockObject.getValue("metadata");
                }
                if (data != null) {
                    CoFHWorld.log.warn("Using `metadata` (at line: {}) for blocks is deprecated, and will be removed in the future. Use `properties` instead.", (Object)data.origin().lineNumber());
                    if (data.valueType() != ConfigValueType.NUMBER) {
                        data = null;
                    }
                }
                int metadata = data != null ? MathHelper.func_76125_a((int)((Number)data.unwrapped()).intValue(), (int)min, (int)15) : min;
                return new WeightedBlock(block, metadata, dataTag, weight);
            }
            case STRING: {
                Block block = BlockData.parseBlock((String)blockEntry.unwrapped());
                if (block == null) {
                    CoFHWorld.log.error("Invalid block name on line {}!", (Object)blockEntry.origin().lineNumber());
                    return null;
                }
                return new WeightedBlock(block, min);
            }
        }
        CoFHWorld.log.error("Invalid type for block entry on line!", (Object)blockEntry.origin().lineNumber());
        return null;
    }

    private static Block parseBlock(String blockName) {
        ResourceLocation loc = new ResourceLocation(blockName);
        if (ForgeRegistries.BLOCKS.containsKey(loc)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(loc);
        }
        return null;
    }

    private static <T extends Comparable<T>> IBlockState setValue(IBlockState state, IProperty<T> prop, String val) {
        Optional value = prop.func_185929_b(val);
        if (!value.isPresent()) {
            Object[] valid = prop.func_177700_c().stream().map(arg_0 -> prop.func_177702_a(arg_0)).collect(Collectors.toList()).toArray(new String[0]);
            CoFHWorld.log.error("Unknown value `{}` for property '{}'; allowed values are: \n{}", (Object)val, (Object)prop.func_177701_a(), (Object)Arrays.toString(valid));
            return null;
        }
        return state.func_177226_a(prop, (Comparable)value.get());
    }
}

