/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.blocks;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolspower.blocks.InformationScreenTileEntity;
import mcjty.rftoolspower.network.PacketGetMonitorLog;
import mcjty.rftoolspower.network.RFToolsPowerMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InformationScreenRenderer
extends TileEntitySpecialRenderer<InformationScreenTileEntity> {
    private static DecimalFormat format = new DecimalFormat("#.###");

    public void render(InformationScreenTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        InformationScreenRenderer.renderHud(te, x, y, z);
    }

    public static void renderHud(InformationScreenTileEntity hudinfoscreen, double x, double y, double z) {
        InformationScreenRenderer.renderHud(hudinfoscreen, x, y, z, 0.3f, false);
    }

    public static void renderHud(InformationScreenTileEntity infoscreen, double x, double y, double z, float scale, boolean faceVert) {
        EnumFacing orientation;
        long t = System.currentTimeMillis();
        if (t - infoscreen.getLastUpdateTime() > 250L) {
            RFToolsPowerMessages.INSTANCE.sendToServer((IMessage)new PacketGetMonitorLog(infoscreen.func_174877_v()));
            infoscreen.setLastUpdateTime(t);
        }
        if ((orientation = infoscreen.getBlockOrientation()) == null) {
            return;
        }
        EnergyTools.EnergyLevel power = infoscreen.getClientPower();
        if (infoscreen.getMode() == 0 || power == null) {
            List<String> log = InformationScreenRenderer.getLog(power, infoscreen);
            HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
            HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
            HudRenderHelper.renderHud(log, (HudRenderHelper.HudPlacement)hudPlacement, (HudRenderHelper.HudOrientation)hudOrientation, (EnumFacing)orientation, (double)(x - (double)orientation.func_82601_c() * 0.95), (double)y, (double)(z - (double)orientation.func_82599_e() * 0.95), (float)(1.0f + scale));
        } else {
            InformationScreenRenderer.renderGraphical(power, orientation, x - (double)orientation.func_82601_c() * 0.95, y, z - (double)orientation.func_82599_e() * 0.95, 1.0f + scale, infoscreen);
        }
    }

    private static List<String> getLog(EnergyTools.EnergyLevel power, InformationScreenTileEntity infoscreen) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (power != null) {
            long energy = power.getEnergy();
            long maxEnergy = power.getMaxEnergy();
            list.add(TextFormatting.BLUE + " RF: " + TextFormatting.WHITE + InformationScreenRenderer.formatPower(energy));
            list.add(TextFormatting.BLUE + " Max: " + TextFormatting.WHITE + InformationScreenRenderer.formatPower(maxEnergy));
            if (infoscreen.getRfExtractPerTick() != -1L) {
                list.add(TextFormatting.BLUE + " Ext/t: " + TextFormatting.WHITE + InformationScreenRenderer.formatPower(infoscreen.getRfExtractPerTick()));
                list.add(TextFormatting.BLUE + " Ins/t: " + TextFormatting.WHITE + InformationScreenRenderer.formatPower(infoscreen.getRfInsertedPerTick()));
            }
        } else {
            list.add(TextFormatting.RED + " Not a powercell");
            list.add(TextFormatting.RED + " or anything that");
            list.add(TextFormatting.RED + " supports power");
        }
        return list;
    }

    private static String formatPower(long l) {
        if (l < 100000L) {
            return Long.toString(l);
        }
        if (l < 10000000L) {
            Double d = (double)l / 1000.0;
            return format.format(d) + "K";
        }
        if (l < 10000000000L) {
            Double d = (double)l / 1000000.0;
            return format.format(d) + "M";
        }
        Double d = (double)l / 1.0E9;
        return format.format(d) + "G";
    }

    public static void renderGraphical(EnergyTools.EnergyLevel power, EnumFacing orientation, double x, double y, double z, float scale, InformationScreenTileEntity infoscreen) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)(-InformationScreenRenderer.getHudAngle(orientation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.4625);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        if (power.getMaxEnergy() > 0L) {
            long roughMax;
            int mode = infoscreen.getMode();
            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.07f);
            float f3 = 0.0075f;
            GlStateManager.func_179152_a((float)(f3 * scale), (float)(-f3 * scale), (float)f3);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            long pct = power.getEnergy() * 100L / power.getMaxEnergy();
            for (int i = 0; i < 100; i += 5) {
                int col = (long)i < pct ? InformationScreenRenderer.getPercentageColor(i) : -15658735;
                RenderHelper.drawFlatBox((int)16, (int)((int)(100.0 - (double)i * 0.8 - 13.0)), (int)(mode == 1 ? 88 : 44), (int)((int)(100.0 - (double)i * 0.8 + 3.0 - 13.0)), (int)col, (int)col);
            }
            if (mode == 2 && (roughMax = infoscreen.getRoughMaxRfPerTick()) > 0L) {
                long inserted = infoscreen.getRfInsertedPerTick();
                long extracted = infoscreen.getRfExtractPerTick();
                long pctInserted = Math.max(0L, Math.min(100L, inserted * 100L / roughMax));
                RenderHelper.drawFlatBox((int)60, (int)20, (int)90, (int)50, (int)-1, (int)(-16777216 + (int)((float)pctInserted * 2.5f)));
                long pctExtracted = Math.max(0L, Math.min(100L, extracted * 100L / roughMax));
                int mask = (int)((float)pctExtracted * 2.5f);
                RenderHelper.drawFlatBox((int)60, (int)54, (int)90, (int)84, (int)-1, (int)(-16777216 + (mask << 16) + (mask << 8)));
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179121_F();
    }

    private static int getPercentageColor(int i) {
        int col = i < 30 ? -16711936 : (i < 40 ? -14492416 : (i < 50 ? -12272896 : (i < 60 ? -10053376 : (i < 70 ? -7833856 : (i < 80 ? -5614336 : (i < 90 ? -3394816 : -1175296))))));
        return col;
    }

    private static float getHudAngle(EnumFacing orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }
}

