/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.rftoolspower.blocks.PowerCellBlock;
import mcjty.rftoolspower.blocks.SideType;
import mcjty.rftoolspower.blocks.Tier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class GenericCellBakedModel
implements IBakedModel {
    public static final ModelResourceLocation modelCell = new ModelResourceLocation("rftoolspower:cell1");
    private static Map<String, TextureAtlasSprite> sideSpriteMap = new HashMap<String, TextureAtlasSprite>();
    private static Map<String, TextureAtlasSprite> topSpriteMap = new HashMap<String, TextureAtlasSprite>();
    private VertexFormat format;
    private static TextureAtlasSprite inputMask;
    private static TextureAtlasSprite outputMask;

    private static TextureAtlasSprite getInputMask() {
        if (inputMask == null) {
            inputMask = Minecraft.func_71410_x().func_147117_R().func_110572_b("rftoolspower:blocks/inputmask");
        }
        return inputMask;
    }

    private static TextureAtlasSprite getOutputMask() {
        if (outputMask == null) {
            outputMask = Minecraft.func_71410_x().func_147117_R().func_110572_b("rftoolspower:blocks/outputmask");
        }
        return outputMask;
    }

    private static TextureAtlasSprite getSideTexture(SideType type, int tier) {
        String key = type.func_176610_l() + tier;
        if (!sideSpriteMap.containsKey(key)) {
            sideSpriteMap.put(key, Minecraft.func_71410_x().func_147117_R().func_110572_b(type.getSideTexture() + tier));
        }
        return sideSpriteMap.get(key);
    }

    private static TextureAtlasSprite getTopTexture(SideType type, int tier) {
        String key = type.func_176610_l();
        if (!topSpriteMap.containsKey(key)) {
            topSpriteMap.put(key, Minecraft.func_71410_x().func_147117_R().func_110572_b(type.getUpDownTexture()));
        }
        return topSpriteMap.get(key);
    }

    public GenericCellBakedModel(VertexFormat format) {
        this.format = format;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float color) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{color, color, color, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, float hilight) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, hilight);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite, hilight);
        return builder.build();
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        SideType north = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.NORTH));
        SideType south = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.SOUTH));
        SideType west = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.WEST));
        SideType east = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.EAST));
        SideType up = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.UP));
        SideType down = (SideType)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.DOWN));
        Tier tier = (Tier)((Object)extendedBlockState.getValue((IUnlistedProperty)PowerCellBlock.TIER));
        int t = tier.ordinal() + 1;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float hilight = 1.0f;
        float o = 0.25f;
        if (up != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(0.0, 1.0, 0.0), GenericCellBakedModel.v(0.0, 1.0, 1.0), GenericCellBakedModel.v(1.0, 1.0, 1.0), GenericCellBakedModel.v(1.0, 1.0, 0.0), GenericCellBakedModel.getTopTexture(up, t), hilight));
            if (up.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, 1.02, o), GenericCellBakedModel.v(o, 1.02, 1.0f - o), GenericCellBakedModel.v(1.0f - o, 1.02, 1.0f - o), GenericCellBakedModel.v(1.0f - o, 1.02, o), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (up.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, 1.02, o), GenericCellBakedModel.v(o, 1.02, 1.0f - o), GenericCellBakedModel.v(1.0f - o, 1.02, 1.0f - o), GenericCellBakedModel.v(1.0f - o, 1.02, o), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        if (down != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(0.0, 0.0, 0.0), GenericCellBakedModel.v(1.0, 0.0, 0.0), GenericCellBakedModel.v(1.0, 0.0, 1.0), GenericCellBakedModel.v(0.0, 0.0, 1.0), GenericCellBakedModel.getTopTexture(down, t), hilight));
            if (down.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, -0.02, o), GenericCellBakedModel.v(1.0f - o, -0.02, o), GenericCellBakedModel.v(1.0f - o, -0.02, 1.0f - o), GenericCellBakedModel.v(o, -0.02, 1.0f - o), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (down.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, -0.02, o), GenericCellBakedModel.v(1.0f - o, -0.02, o), GenericCellBakedModel.v(1.0f - o, -0.02, 1.0f - o), GenericCellBakedModel.v(o, -0.02, 1.0f - o), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        if (east != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(1.0, 1.0, 1.0), GenericCellBakedModel.v(1.0, 0.0, 1.0), GenericCellBakedModel.v(1.0, 0.0, 0.0), GenericCellBakedModel.v(1.0, 1.0, 0.0), GenericCellBakedModel.getSideTexture(east, t), hilight));
            if (east.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(1.02, 1.0f - o, 1.0f - o), GenericCellBakedModel.v(1.02, o, 1.0f - o), GenericCellBakedModel.v(1.02, o, o), GenericCellBakedModel.v(1.02, 1.0f - o, o), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (east.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(1.02, 1.0f - o, 1.0f - o), GenericCellBakedModel.v(1.02, o, 1.0f - o), GenericCellBakedModel.v(1.02, o, o), GenericCellBakedModel.v(1.02, 1.0f - o, o), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        if (west != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(0.0, 1.0, 0.0), GenericCellBakedModel.v(0.0, 0.0, 0.0), GenericCellBakedModel.v(0.0, 0.0, 1.0), GenericCellBakedModel.v(0.0, 1.0, 1.0), GenericCellBakedModel.getSideTexture(west, t), hilight));
            if (west.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(-0.02, 1.0f - o, o), GenericCellBakedModel.v(-0.02, o, o), GenericCellBakedModel.v(-0.02, o, 1.0f - o), GenericCellBakedModel.v(-0.02, 1.0f - o, 1.0f - o), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (west.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(-0.02, 1.0f - o, o), GenericCellBakedModel.v(-0.02, o, o), GenericCellBakedModel.v(-0.02, o, 1.0f - o), GenericCellBakedModel.v(-0.02, 1.0f - o, 1.0f - o), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        if (north != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(1.0, 1.0, 0.0), GenericCellBakedModel.v(1.0, 0.0, 0.0), GenericCellBakedModel.v(0.0, 0.0, 0.0), GenericCellBakedModel.v(0.0, 1.0, 0.0), GenericCellBakedModel.getSideTexture(north, t), hilight));
            if (north.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(1.0f - o, 1.0f - o, -0.02), GenericCellBakedModel.v(1.0f - o, o, -0.02), GenericCellBakedModel.v(o, o, -0.02), GenericCellBakedModel.v(o, 1.0f - o, -0.02), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (north.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(1.0f - o, 1.0f - o, -0.02), GenericCellBakedModel.v(1.0f - o, o, -0.02), GenericCellBakedModel.v(o, o, -0.02), GenericCellBakedModel.v(o, 1.0f - o, -0.02), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        if (south != SideType.INVISIBLE) {
            quads.add(this.createQuad(GenericCellBakedModel.v(0.0, 1.0, 1.0), GenericCellBakedModel.v(0.0, 0.0, 1.0), GenericCellBakedModel.v(1.0, 0.0, 1.0), GenericCellBakedModel.v(1.0, 1.0, 1.0), GenericCellBakedModel.getSideTexture(south, t), hilight));
            if (south.isInput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, 1.0f - o, 1.02), GenericCellBakedModel.v(o, o, 1.02), GenericCellBakedModel.v(1.0f - o, o, 1.02), GenericCellBakedModel.v(1.0f - o, 1.0f - o, 1.02), GenericCellBakedModel.getInputMask(), hilight));
            }
            if (south.isOutput()) {
                quads.add(this.createQuad(GenericCellBakedModel.v(o, 1.0f - o, 1.02), GenericCellBakedModel.v(o, o, 1.02), GenericCellBakedModel.v(1.0f - o, o, 1.02), GenericCellBakedModel.v(1.0f - o, 1.0f - o, 1.02), GenericCellBakedModel.getOutputMask(), hilight));
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return GenericCellBakedModel.getSideTexture(SideType.BOTH_NONE, 1);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

