/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.util;

import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.client.BarrelModel;
import com.latmod.yabba.client.YabbaClient;
import com.latmod.yabba.util.EnumBarrelModel;
import javax.annotation.Nullable;

public class BarrelLook {
    public static final BarrelLook DEFAULT = new BarrelLook(EnumBarrelModel.BARREL, "");
    public static final String DEFAULT_SKIN_ID = "minecraft:planks_oak";
    public final EnumBarrelModel model;
    public final String skin;

    public static BarrelLook get(EnumBarrelModel m, @Nullable String s) {
        if (s == null || !s.isEmpty() && s.equals(DEFAULT_SKIN_ID)) {
            s = "";
        }
        return m.isDefault() && s.isEmpty() ? DEFAULT : new BarrelLook(m, s);
    }

    public static BarrelLook get(BarrelModel m, BarrelSkin s) {
        return BarrelLook.get(m.id, s.id);
    }

    private BarrelLook(EnumBarrelModel m, String s) {
        this.model = m;
        this.skin = s;
    }

    public int hashCode() {
        return this.skin.hashCode() ^ this.model.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BarrelLook) {
            BarrelLook key = (BarrelLook)o;
            return this.model == key.model && this.skin.equals(key.skin);
        }
        return false;
    }

    public String toString() {
        return this.model.func_176610_l() + ":" + (this.skin.isEmpty() ? DEFAULT_SKIN_ID : this.skin);
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public BarrelModel getModel() {
        return this.model.getModel();
    }

    public BarrelSkin getSkin() {
        return YabbaClient.getSkin(this.skin);
    }
}

