/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.tile.IBarrelBase;
import com.latmod.yabba.tile.IItemBarrel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemBarrelConnector
extends TileBase
implements IItemHandler {
    private static final HashSet<TileItemBarrelConnector> ALL_CONNECTORS = new HashSet();
    private static BlockPos currentPos = null;
    private static final Comparator<IItemBarrel> BARREL_COMPARATOR = (o1, o2) -> {
        int i = Boolean.compare(o1.getStoredItemType().func_190926_b(), o2.getStoredItemType().func_190926_b());
        i = i == 0 ? Boolean.compare(o2.isLocked(), o1.isLocked()) : i;
        return i == 0 ? Double.compare(currentPos.func_177951_i((Vec3i)((TileEntity)o1).func_174877_v()), currentPos.func_177951_i((Vec3i)((TileEntity)o2).func_174877_v())) : i;
    };
    public final List<IItemBarrel> linkedBarrels = new ArrayList<IItemBarrel>();
    private long lastUpdate = 0L;

    public static void markAllDirty(BlockPos pos, int dimension) {
        Iterator<TileItemBarrelConnector> iterator = ALL_CONNECTORS.iterator();
        while (iterator.hasNext()) {
            TileItemBarrelConnector connector = iterator.next();
            if (connector.func_145837_r()) {
                iterator.remove();
                continue;
            }
            if (connector.field_145850_b == null || dimension != connector.field_145850_b.field_73011_w.getDimension() || !(connector.field_174879_c.func_177951_i((Vec3i)pos) <= 65536.0)) continue;
            connector.lastUpdate = 0L;
        }
    }

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    public void func_145829_t() {
        super.func_145829_t();
        ALL_CONNECTORS.add(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ALL_CONNECTORS.remove((Object)this);
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    public boolean notifyBlock() {
        return false;
    }

    private void addToList(HashSet<IItemBarrel> scanned, BlockPos pos, EnumFacing from) {
        IItemHandler itemHandler;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from) && (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from)) instanceof IItemBarrel && scanned.add((IItemBarrel)itemHandler)) {
            for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                if (facing1 == from) continue;
                this.addToList(scanned, pos.func_177972_a(facing1), facing1.func_176734_d());
            }
        }
    }

    @Nullable
    private IItemBarrel getAt(int slot) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        if (this.field_145850_b.func_82737_E() - this.lastUpdate >= (long)YabbaConfig.general.connector_update_ticks) {
            this.lastUpdate = this.field_145850_b.func_82737_E();
            this.linkedBarrels.clear();
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                HashSet<IItemBarrel> scanned = new HashSet<IItemBarrel>();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    this.addToList(scanned, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
                }
                this.linkedBarrels.addAll(scanned);
                currentPos = this.field_174879_c;
                this.linkedBarrels.sort(BARREL_COMPARATOR);
            }
        }
        IBarrelBase barrel = slot < 0 || slot >= this.linkedBarrels.size() ? null : this.linkedBarrels.get(slot);
        return barrel == null || barrel.isBarrelInvalid() ? null : barrel;
    }

    public int getSlots() {
        this.getAt(-1);
        return this.linkedBarrels.size();
    }

    public ItemStack getStackInSlot(int slot) {
        IItemBarrel barrel = this.getAt(slot);
        return barrel == null ? ItemStack.field_190927_a : barrel.getStackInSlot(0);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        IItemBarrel barrel = this.getAt(slot);
        return barrel == null ? stack : barrel.insertItem(0, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IItemBarrel barrel = this.getAt(slot);
        return barrel == null ? ItemStack.field_190927_a : barrel.extractItem(0, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        IItemBarrel barrel = this.getAt(slot);
        return barrel == null ? 64 : barrel.getSlotLimit(0);
    }
}

