/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftblib.lib.util.misc.DataStorage;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.RemoveUpgradeEvent;
import com.latmod.yabba.api.YabbaConfigEvent;
import com.latmod.yabba.block.Tier;
import com.latmod.yabba.item.IUpgrade;
import com.latmod.yabba.item.upgrade.ItemUpgradeHopper;
import com.latmod.yabba.item.upgrade.ItemUpgradeRedstone;
import com.latmod.yabba.tile.IBarrelBase;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.UpgradeInst;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileBarrelBase
extends TileBase
implements IBarrelBase {
    protected Tier tier = Tier.WOOD;
    public Map<Item, UpgradeInst> upgrades = new HashMap<Item, UpgradeInst>();
    protected boolean isLocked = false;

    public TileBarrelBase() {
        this.func_145836_u();
    }

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (this.tier != Tier.WOOD) {
            nbt.func_74778_a("Tier", this.tier.func_176610_l());
        }
        if (!this.upgrades.isEmpty()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            for (UpgradeInst inst : this.upgrades.values()) {
                ResourceLocation id = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)inst.getItem());
                if (id == null) continue;
                NBTTagCompound nbt2 = new NBTTagCompound();
                if (!inst.getData().isEmpty()) {
                    inst.getData().serializeNBT(nbt2, type);
                }
                nbt1.func_74782_a(id.toString(), (NBTBase)nbt2);
            }
            nbt.func_74782_a("Upgrades", (NBTBase)nbt1);
        }
        if (this.isLocked) {
            nbt.func_74757_a("Locked", true);
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.func_145836_u();
        this.tier = (Tier)((Object)Tier.NAME_MAP.get(nbt.func_74779_i("Tier")));
        this.upgrades.clear();
        NBTTagCompound upgradeTag = nbt.func_74775_l("Upgrades");
        for (String s : upgradeTag.func_150296_c()) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s));
            if (!(item instanceof IUpgrade)) continue;
            UpgradeInst inst = new UpgradeInst(item);
            if (!inst.getData().isEmpty()) {
                inst.getData().deserializeNBT(upgradeTag.func_74775_l(s), type);
            }
            this.upgrades.put(item, inst);
        }
        this.isLocked = nbt.func_74767_n("Locked");
    }

    @Override
    public void markBarrelDirty(boolean majorChange) {
        if (majorChange) {
            this.func_145836_u();
        }
        this.func_70296_d();
    }

    public void onUpdatePacket(EnumSaveType type) {
    }

    public void func_70296_d() {
    }

    @Override
    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void setLocked(boolean b) {
        if (this.isLocked != b) {
            this.isLocked = b;
            this.markBarrelDirty(true);
        }
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public boolean setTier(Tier t, boolean simulate) {
        if (this.tier != t) {
            if (!simulate) {
                this.tier = t;
                this.markBarrelDirty(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public BarrelLook getLook() {
        return BarrelLook.DEFAULT;
    }

    @Override
    public boolean setLook(BarrelLook look, boolean simulate) {
        return false;
    }

    @Override
    public DataStorage getUpgradeData(Item upgrade) {
        UpgradeInst inst = this.upgrades.get(upgrade);
        return inst == null ? DataStorage.EMPTY : inst.getData();
    }

    @Override
    public boolean hasUpgrade(Item upgrade) {
        return !this.upgrades.isEmpty() && this.upgrades.containsKey(upgrade);
    }

    @Override
    public boolean removeUpgrade(Item upgrade, boolean simulate) {
        if (this.hasUpgrade(upgrade)) {
            if (!simulate) {
                UpgradeInst inst = this.upgrades.remove(upgrade);
                inst.getUpgrade().onRemoved(new RemoveUpgradeEvent(this, inst));
                this.markBarrelDirty(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addUpgrade(Item upgrade, boolean simulate) {
        if (upgrade instanceof IUpgrade && !this.hasUpgrade(upgrade)) {
            if (!simulate) {
                this.upgrades.put(upgrade, new UpgradeInst(upgrade));
                this.markBarrelDirty(true);
            }
            return true;
        }
        return false;
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.markBarrelDirty(true);
    }

    public void createConfig(YabbaConfigEvent event) {
        ConfigGroup group;
        DataStorage data = this.getUpgradeData(YabbaItems.UPGRADE_REDSTONE_OUT);
        if (data instanceof ItemUpgradeRedstone.Data) {
            group = event.getConfig().getGroup("redstone");
            group.setDisplayName((ITextComponent)new TextComponentTranslation(YabbaItems.UPGRADE_REDSTONE_OUT.func_77658_a() + ".name", new Object[0]));
            ((ItemUpgradeRedstone.Data)data).getConfig(group);
        }
        if ((data = this.getUpgradeData(YabbaItems.UPGRADE_HOPPER)) instanceof ItemUpgradeHopper.Data) {
            group = event.getConfig().getGroup("hopper");
            group.setDisplayName((ITextComponent)new TextComponentTranslation(YabbaItems.UPGRADE_HOPPER.func_77658_a() + ".name", new Object[0]));
            ((ItemUpgradeHopper.Data)data).getConfig(group);
        }
    }

    @Override
    public final void openGui(EntityPlayer player) {
        ConfigGroup main = ConfigGroup.newGroup((String)"barrel_config");
        main.setDisplayName(this.func_145748_c_());
        YabbaConfigEvent event = new YabbaConfigEvent(this, main, player);
        event.post();
        this.createConfig(event);
        FTBLibAPI.editServerConfig((EntityPlayerMP)((EntityPlayerMP)player), (ConfigGroup)main, (IConfigCallback)this);
    }

    @Override
    public boolean isBarrelInvalid() {
        return this.func_145837_r();
    }

    public void writeToPickBlock(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        BarrelLook look = this.getLook();
        if (!look.model.isDefault()) {
            nbt.func_74778_a("Model", look.model.getNBTName());
        }
        if (!look.skin.isEmpty()) {
            nbt.func_74778_a("Skin", look.skin);
        }
        if (!nbt.func_82582_d()) {
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbt);
        }
    }
}

