/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.item;

import com.latmod.yabba.gui.GuiSelectModel;
import com.latmod.yabba.tile.ITileWithBarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHammer
extends Item {
    public static EnumBarrelModel getModel(ItemStack stack) {
        return stack.func_77942_o() ? EnumBarrelModel.getFromNBTName(stack.func_77978_p().func_74779_i("Model")) : EnumBarrelModel.BARREL;
    }

    public static void setModel(ItemStack stack, EnumBarrelModel modelId) {
        stack.func_77983_a("Model", (NBTBase)new NBTTagString(modelId.func_176610_l()));
    }

    public ItemHammer() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && playerIn.func_70093_af()) {
            if (worldIn.field_72995_K) {
                this.openModelGui();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(hand));
    }

    private void openModelGui() {
        new GuiSelectModel().openGui();
    }

    public static String getModelTooltip(EnumBarrelModel model) {
        return I18n.func_135052_a((String)"lang.yabba.model", (Object[])new Object[]{I18n.func_135052_a((String)model.getUnlocalizedName(), (Object[])new Object[0])});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemHammer.getModelTooltip(ItemHammer.getModel(stack)));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITileWithBarrelLook) {
            ((ITileWithBarrelLook)tileEntity).setModel(ItemHammer.getModel(player.func_184586_b(hand)), false);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

