/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.integration;

import com.feed_the_beast.ftblib.lib.util.misc.TextureSet;
import com.latmod.yabba.Yabba;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.api.YabbaSkinsEvent;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="yabba", value={Side.CLIENT})
public class ForestryIntegration {
    @SubscribeEvent
    public static void registerSkins(YabbaSkinsEvent event) {
        if (Loader.isModLoaded((String)"forestry")) {
            ForestryIntegration.registerSkins0(event);
        }
    }

    private static void registerSkins0(YabbaSkinsEvent event) {
        Yabba.LOGGER.info("Loading Forestry Integration");
        for (IWoodType type : TreeManager.woodAccess.getRegisteredWoodTypes()) {
            if (type instanceof EnumVanillaWoodType) continue;
            try {
                BarrelSkin skin = new BarrelSkin("forestry:planks_" + type.func_176610_l(), TextureSet.of((String)("all=" + type.getPlankTexture())));
                try {
                    skin.state = TreeManager.woodAccess.getBlock(type, WoodBlockKind.PLANKS, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                skin.displayName = TreeManager.woodAccess.getStack(type, WoodBlockKind.PLANKS, false).func_82833_r();
                event.addSkin(skin);
                skin = new BarrelSkin("forestry:log_" + type.func_176610_l(), TextureSet.of((String)("up&down=" + type.getHeartTexture() + ",all=" + type.getBarkTexture())));
                try {
                    skin.state = TreeManager.woodAccess.getBlock(type, WoodBlockKind.LOG, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                skin.displayName = TreeManager.woodAccess.getStack(type, WoodBlockKind.LOG, false).func_82833_r();
                event.addSkin(skin);
            }
            catch (Exception exception) {}
        }
    }
}

