/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.TextureSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.yabba.Yabba;
import com.latmod.yabba.YabbaBlocks;
import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.api.YabbaSkinsEvent;
import com.latmod.yabba.client.BarrelModel;
import com.latmod.yabba.client.BarrelModelLoader;
import com.latmod.yabba.client.YabbaClientConfig;
import com.latmod.yabba.tile.TileDecorativeBlock;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class YabbaClient
extends YabbaCommon {
    public static final Collection<ResourceLocation> TEXTURES = new HashSet<ResourceLocation>();
    private static final Map<String, BarrelSkin> SKINS = new HashMap<String, BarrelSkin>();
    public static final List<BarrelSkin> ALL_SKINS = new ArrayList<BarrelSkin>();
    private static BarrelSkin DEFAULT_SKIN;
    private static final Map<String, String> VARIABLES;
    private static final YabbaSkinsEvent.Callback REGISTER_SKIN;

    private static String parseVariableString(String s) {
        if (!VARIABLES.isEmpty()) {
            for (Map.Entry<String, String> entry : VARIABLES.entrySet()) {
                s = s.replace('$' + entry.getKey(), entry.getValue());
            }
        }
        return s;
    }

    public static void loadModelsAndSkins() {
        ItemStack stack;
        TileDecorativeBlock tile;
        TEXTURES.clear();
        SKINS.clear();
        ALL_SKINS.clear();
        IResourceManager manager = ClientUtils.MC.func_110442_L();
        for (EnumBarrelModel id : EnumBarrelModel.NAME_MAP) {
            try {
                JsonObject modelFile = DataReader.get((IResource)manager.func_110536_a(new ResourceLocation("yabba", "yabba_models/" + id.func_176610_l() + ".json"))).json().getAsJsonObject();
                BarrelModel model = new BarrelModel(id, modelFile);
                id.setModel(model);
                for (TextureSet textureSet : model.textures.values()) {
                    TEXTURES.addAll(textureSet.getTextures());
                }
            }
            catch (Exception modelFile) {
            }
        }
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "yabba_models/_skins.json"))) {
                    YabbaClient.parseSkinsJson(DataReader.get((IResource)resource).json().getAsJsonArray());
                    VARIABLES.clear();
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack stack2 = new FluidStack(fluid, 1000);
            String displayName = stack2.getLocalizedName();
            Color4I color = Color4I.rgba((int)fluid.getColor(stack2));
            if (color.equals((Object)Color4I.WHITE)) {
                color = Icon.EMPTY;
            }
            ResourceLocation still = fluid.getStill(stack2);
            BarrelSkin skin = new BarrelSkin(fluid.getName() + "_still", TextureSet.of((String)("all=" + still)));
            skin.displayName = I18n.func_135052_a((String)"lang.fluid.still", (Object[])new Object[]{displayName});
            skin.color = color;
            skin.layer = BlockRenderLayer.TRANSLUCENT;
            REGISTER_SKIN.addSkin(skin);
            ResourceLocation flowing = fluid.getFlowing(stack2);
            if (still.equals((Object)flowing)) continue;
            skin = new BarrelSkin(fluid.getName() + "_flowing", TextureSet.of((String)("up&down=" + still + ",all=" + flowing)));
            skin.displayName = I18n.func_135052_a((String)"lang.fluid.flowing", (Object[])new Object[]{displayName});
            skin.color = color;
            skin.layer = BlockRenderLayer.TRANSLUCENT;
            REGISTER_SKIN.addSkin(skin);
        }
        new YabbaSkinsEvent(REGISTER_SKIN).post();
        for (BarrelSkin skin : SKINS.values()) {
            if (skin.displayName.isEmpty() && skin.state != BlockUtils.AIR_STATE) {
                try {
                    skin.displayName = new ItemStack(skin.state.func_177230_c(), 1, skin.state.func_177230_c().func_176201_c(skin.state)).func_82833_r();
                }
                catch (Exception stack2) {
                    // empty catch block
                }
            }
            if (skin.displayName.isEmpty() || skin.displayName.contains("air")) {
                skin.displayName = "";
            }
            if (!skin.icon.isEmpty()) continue;
            tile = new TileDecorativeBlock();
            tile.setLook(BarrelLook.get(EnumBarrelModel.BLOCK, skin.id), false);
            stack = new ItemStack(YabbaItems.DECORATIVE_BLOCK);
            tile.writeToPickBlock(stack);
            skin.icon = ItemIcon.getItemIcon((ItemStack)stack);
        }
        ALL_SKINS.addAll(SKINS.values());
        ALL_SKINS.sort(StringUtils.ID_COMPARATOR);
        DEFAULT_SKIN = SKINS.get("minecraft:planks_oak");
        if (DEFAULT_SKIN == null) {
            DEFAULT_SKIN = ALL_SKINS.isEmpty() ? null : ALL_SKINS.get(0);
        }
        Yabba.LOGGER.info("Skins: " + ALL_SKINS.size());
        for (EnumBarrelModel id : EnumBarrelModel.NAME_MAP) {
            tile = new TileDecorativeBlock();
            tile.setLook(BarrelLook.get(id, ""), false);
            stack = new ItemStack(YabbaItems.DECORATIVE_BLOCK);
            tile.writeToPickBlock(stack);
            id.getModel().icon = ItemIcon.getItemIcon((ItemStack)stack);
        }
    }

    private static Iterable<List<String>> getIterator(JsonElement e) {
        ArrayList<List<String>> l = new ArrayList<List<String>>();
        if (e.isJsonArray()) {
            for (JsonElement e1 : e.getAsJsonArray()) {
                if (e1.isJsonArray()) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (JsonElement e2 : e1.getAsJsonArray()) {
                        list.add(e2.getAsString());
                    }
                    l.add(list);
                    continue;
                }
                l.add(Collections.singletonList(YabbaClient.parseVariableString(e1.getAsString())));
            }
            return l;
        }
        String s = YabbaClient.parseVariableString(e.getAsString());
        if (s.contains("..")) {
            String[] s1 = s.split("..");
            int min = Integer.parseInt(s1[0]);
            int max = Integer.parseInt(s1[1]);
            for (int i = min; i <= max; ++i) {
                l.add(Collections.singletonList(Integer.toString(i)));
            }
            return l;
        }
        String[] s1 = s.split("#");
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s1[0]));
        IProperty property = block.func_176194_O().func_185920_a(s1[1]);
        if (property != null) {
            for (Object o : property.func_177700_c()) {
                l.add(Collections.singletonList(property.func_177702_a((Comparable)CommonUtils.cast(o))));
            }
        }
        return l;
    }

    private static void parseSkinsJson(JsonArray array) {
        for (JsonElement element : array) {
            try {
                JsonArray a;
                if (!element.isJsonObject()) continue;
                JsonObject json = element.getAsJsonObject();
                if (json.has("add")) {
                    ResourceLocation id = new ResourceLocation(YabbaClient.parseVariableString(json.get("add").getAsString()));
                    TextureSet textures = json.has("textures") ? TextureSet.of((String)YabbaClient.parseVariableString(json.get("textures").getAsString())) : TextureSet.of((String)("all=" + id.func_110624_b() + ":blocks/" + id.func_110623_a()));
                    BarrelSkin skin = new BarrelSkin(id.toString(), textures);
                    if (json.has("name")) {
                        skin.displayName = JsonUtils.deserializeTextComponent((JsonElement)json.get("name")).func_150254_d();
                    }
                    if (json.has("icon")) {
                        skin.icon = Icon.getIcon((JsonElement)json.get("icon"));
                    }
                    if (json.has("layer")) {
                        skin.layer = (BlockRenderLayer)ClientUtils.BLOCK_RENDER_LAYER_NAME_MAP.get(json.get("layer").getAsString());
                    }
                    if (json.has("color")) {
                        skin.color = Color4I.fromJson((JsonElement)json.get("color"));
                    }
                    skin.state = BlockUtils.getStateFromName((String)(json.has("state") ? YabbaClient.parseVariableString(json.get("state").getAsString()) : skin.id));
                    REGISTER_SKIN.addSkin(skin);
                    continue;
                }
                if (json.has("set")) {
                    VARIABLES.put(YabbaClient.parseVariableString(json.get("set").getAsString()), YabbaClient.parseVariableString(json.get("value").getAsString()));
                    continue;
                }
                if (!json.has("for") || (a = json.get("for").getAsJsonArray()).size() != 3) continue;
                String key = a.get(0).getAsString();
                for (List<String> value : YabbaClient.getIterator(a.get(1))) {
                    if (value.size() == 1) {
                        VARIABLES.put(key, YabbaClient.parseVariableString(value.get(0)));
                    } else {
                        for (int i = 0; i < value.size(); ++i) {
                            VARIABLES.put(key + "" + i, YabbaClient.parseVariableString(value.get(i)));
                        }
                    }
                    YabbaClient.parseSkinsJson(JsonUtils.toArray((JsonElement)a.get(2)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void preInit() {
        YabbaClientConfig.sync();
    }

    @Override
    public void postInit() {
        Block[] blocks = new Block[]{YabbaBlocks.ITEM_BARREL, YabbaBlocks.DECORATIVE_BLOCK};
        ClientUtils.MC.func_184125_al().func_186722_a((IBlockColor)BarrelModelLoader.INSTANCE, blocks);
        ClientUtils.MC.getItemColors().func_186731_a((IItemColor)BarrelModelLoader.INSTANCE, blocks);
    }

    public static BarrelSkin getSkin(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return DEFAULT_SKIN;
        }
        BarrelSkin skin = SKINS.get(id);
        return skin == null ? DEFAULT_SKIN : skin;
    }

    static {
        VARIABLES = new HashMap<String, String>();
        REGISTER_SKIN = skin -> {
            SKINS.put(skin.id, skin);
            TEXTURES.addAll(skin.textures.getTextures());
        };
    }
}

