/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.client.ModelBase;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.block.BlockAdvancedBarrelBase;
import com.latmod.yabba.client.BakedBarrelItemModel;
import com.latmod.yabba.client.BarrelBlockModelKey;
import com.latmod.yabba.client.BarrelBlockModelVariant;
import com.latmod.yabba.client.BarrelModel;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedBarrelBlockModel
extends ModelBase {
    private final VertexFormat format;
    private final Map<BarrelLook, IBakedModel> itemModels;
    private final Map<BarrelBlockModelKey, BarrelBlockModelVariant> blockModels;
    private static final List<BakedQuad>[] EMPTY = new List[7];
    private final ItemOverrideList itemOverrideList = new ItemOverrideList(Collections.emptyList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            Object bakedModel;
            BarrelLook look = BarrelLook.DEFAULT;
            if (BlockUtils.hasData((ItemStack)stack)) {
                NBTTagCompound data = BlockUtils.getData((ItemStack)stack);
                look = BarrelLook.get(EnumBarrelModel.getFromNBTName(data.func_74779_i("Model")), data.func_74779_i("Skin"));
            }
            if ((bakedModel = (IBakedModel)BakedBarrelBlockModel.this.itemModels.get(look)) == null) {
                BarrelModel model = look.getModel();
                BarrelSkin skin = look.getSkin();
                model.textureMap.put("skin", skin.spriteSet);
                List[] quads = new List[7];
                for (int i = 0; i < 7; ++i) {
                    quads[i] = model.buildItemModel(BakedBarrelBlockModel.this.format, skin, i == 6 ? null : EnumFacing.field_82609_l[i]);
                }
                bakedModel = new BakedBarrelItemModel(BakedBarrelBlockModel.optimize(quads));
                BakedBarrelBlockModel.this.itemModels.put(look, bakedModel);
            }
            return bakedModel;
        }
    };

    public BakedBarrelBlockModel(TextureAtlasSprite p, VertexFormat f) {
        super(p);
        this.format = f;
        this.itemModels = new HashMap<BarrelLook, IBakedModel>();
        this.blockModels = new HashMap<BarrelBlockModelKey, BarrelBlockModelVariant>();
    }

    public boolean func_177555_b() {
        return false;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer layer;
        BarrelLook look;
        BarrelBlockModelKey key;
        BarrelBlockModelVariant variant;
        if (state == null) {
            return Collections.emptyList();
        }
        String skinid = null;
        if (state instanceof IExtendedBlockState) {
            skinid = (String)((IExtendedBlockState)state).getValue(BlockAdvancedBarrelBase.SKIN);
        }
        if ((variant = this.blockModels.get(key = new BarrelBlockModelKey(look = BarrelLook.get((EnumBarrelModel)((Object)state.func_177229_b(BlockAdvancedBarrelBase.MODEL)), skinid), ((EnumFacing)state.func_177229_b(BlockAdvancedBarrelBase.FACING)).func_176736_b()))) == null) {
            BarrelModel model = key.look.getModel();
            BarrelSkin skin = key.look.getSkin();
            ModelRotation rotation = BarrelBlockModelKey.ROTATIONS[((EnumFacing)state.func_177229_b(BlockAdvancedBarrelBase.FACING)).func_176734_d().func_176736_b()];
            model.textureMap.put("skin", skin.spriteSet);
            List[] solidQuads = new List[7];
            List[] cutoutQuads = new List[7];
            List[] translucentQuads = new List[7];
            for (int i = 0; i < 7; ++i) {
                EnumFacing side1 = i == 6 ? null : EnumFacing.field_82609_l[i];
                solidQuads[i] = model.buildModel(this.format, rotation, skin, BlockRenderLayer.SOLID, side1);
                cutoutQuads[i] = model.buildModel(this.format, rotation, skin, BlockRenderLayer.CUTOUT, side1);
                translucentQuads[i] = model.buildModel(this.format, rotation, skin, BlockRenderLayer.TRANSLUCENT, side1);
            }
            variant = new BarrelBlockModelVariant(BakedBarrelBlockModel.optimize(solidQuads), BakedBarrelBlockModel.optimize(cutoutQuads), BakedBarrelBlockModel.optimize(translucentQuads));
            this.blockModels.put(key, variant);
        }
        if ((layer = MinecraftForgeClient.getRenderLayer()) == null) {
            layer = key.look.getSkin().layer;
        }
        int sidei = 6;
        if (side != null) {
            sidei = side.func_176745_a();
        }
        if (layer == BlockRenderLayer.SOLID) {
            return variant.solidQuads[sidei];
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            return variant.translucentQuads[sidei];
        }
        return variant.cutoutQuads[sidei];
    }

    private static List<BakedQuad>[] optimize(List<BakedQuad>[] lists) {
        for (List<BakedQuad> list : lists) {
            if (list.isEmpty()) continue;
            return lists;
        }
        return EMPTY;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    static {
        Arrays.fill(EMPTY, Collections.emptyList());
    }
}

