/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThaumcraftHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        FMLInterModComms.sendMessage((String)"thaumcraft", (String)"harvestStackedCrop", (ItemStack)new ItemStack(IEContent.blockCrop, 5));
        Potion potion_ward = Potion.func_180142_b((String)"thaumcraft:warpward");
        if (potion_ward != null) {
            ChemthrowerHandler.registerEffect("purifying_fluid", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, potion_ward, 100, 0));
        }
        try {
            Class<?> c_DamageSourceThaumcraft = Class.forName("thaumcraft.api.damagesource.DamageSourceThaumcraft");
            if (c_DamageSourceThaumcraft != null) {
                DamageSource dmg_dissolve = (DamageSource)c_DamageSourceThaumcraft.getField("dissolve").get(null);
                ChemthrowerHandler.registerEffect("liquid_death", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Damage(dmg_dissolve, 4.0f));
            }
        }
        catch (Exception c_DamageSourceThaumcraft) {
            // empty catch block
        }
        try {
            Class<?> c_TileSmelter = Class.forName("thaumcraft.common.tiles.essentia.TileSmelter");
            if (c_TileSmelter != null) {
                ExternalHeaterHandler.registerHeatableAdapter(c_TileSmelter, new AlchemyFurnaceAdapter(c_TileSmelter));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void postInit() {
    }

    public static class AlchemyFurnaceAdapter
    extends ExternalHeaterHandler.HeatableAdapter {
        Class c_TileSmelter;
        Method m_canSmelt;
        Field f_furnaceBurnTime;
        Method m_isEnabled;
        Method m_setFurnaceState;

        public AlchemyFurnaceAdapter(Class _class) {
            try {
                this.c_TileSmelter = _class;
                this.m_canSmelt = this.c_TileSmelter.getDeclaredMethod("canSmelt", new Class[0]);
                this.m_canSmelt.setAccessible(true);
                this.f_furnaceBurnTime = this.c_TileSmelter.getDeclaredField("furnaceBurnTime");
                Class<?> c_BlockStateUtils = Class.forName("thaumcraft.common.lib.utils.BlockStateUtils");
                this.m_isEnabled = c_BlockStateUtils.getMethod("isEnabled", IBlockState.class);
                Class<?> c_BlockSmelter = Class.forName("thaumcraft.common.blocks.essentia.BlockSmelter");
                this.m_setFurnaceState = c_BlockSmelter.getMethod("setFurnaceState", World.class, BlockPos.class, Boolean.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean canSmelt(TileEntity tileEntity) throws Exception {
            if (this.m_canSmelt != null) {
                return (Boolean)this.m_canSmelt.invoke((Object)tileEntity, new Object[0]);
            }
            return false;
        }

        public int doHeatTick(TileEntity tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            try {
                boolean canSmelt;
                int time = this.f_furnaceBurnTime.getInt(tileEntity);
                boolean bl = canSmelt = redstone || this.canSmelt(tileEntity);
                if (canSmelt) {
                    int heatEnergyRatio;
                    int heatAttempt;
                    int energyToUse;
                    int heat;
                    if (time < 200 && (heat = (energyToUse = Math.min(energyAvailable, (heatAttempt = Math.min(4, 200 - time)) * (heatEnergyRatio = Math.max(1, ExternalHeaterHandler.defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                        time += heat;
                        energyConsumed += heat * heatEnergyRatio;
                        boolean enabled = (Boolean)this.m_isEnabled.invoke(null, tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()));
                        if (!enabled) {
                            this.m_setFurnaceState.invoke(null, tileEntity.func_145831_w(), tileEntity.func_174877_v(), true);
                        }
                    }
                    this.f_furnaceBurnTime.setInt(tileEntity, time);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return energyConsumed;
        }
    }
}

