/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.items;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.entity.EntityBeeSwarm;
import com.rwtema.careerbees.gui.ContainerBeeGun;
import com.rwtema.careerbees.gui.GuiBeeGun;
import com.rwtema.careerbees.gui.GuiHandler;
import com.rwtema.careerbees.handlers.FakeHousing;
import com.rwtema.careerbees.handlers.SimpleFluidTank;
import com.rwtema.careerbees.lang.Lang;
import com.rwtema.careerbees.networking.BeeNetworking;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class ItemBeeGun
extends Item
implements GuiHandler.ItemStackGuiContainer {
    static int MAX_HONEY = 1000;
    static int HONEY_PER_SHOT = 2;
    int selectedChamber;
    @SideOnly(value=Side.CLIENT)
    ItemStack curItem;
    int timeout = 0;

    public ItemBeeGun() {
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f / 2.0f), (float)1.0f, (float)1.0f);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        HoneyTank capability = (HoneyTank)Validate.notNull((Object)((HoneyTank)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)));
        return 1.0 - (double)capability.getStorage() / (double)capability.getCapacity();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        final BeeStackHandler beeStackHandler = new BeeStackHandler(stack);
        final HoneyTank honeyTank = new HoneyTank(stack);
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)beeStackHandler);
                }
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)honeyTank);
                }
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)honeyTank);
                }
                return null;
            }
        };
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.FAIL;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (heldItem.func_77973_b() != this) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        if (worldIn.field_72995_K) {
            this.sendSlot(playerIn, heldItem);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        if (playerIn.func_70093_af()) {
            playerIn.openGui((Object)BeeMod.instance, 0, worldIn, handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : playerIn.field_71071_by.field_70462_a.size() + playerIn.field_71071_by.field_70460_b.size(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        HoneyTank honeyTank = (HoneyTank)Validate.notNull((Object)(heldItem = heldItem.func_77946_l()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        if (honeyTank.getStorage() == 0) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        NBTTagCompound nbt = heldItem.func_77978_p();
        if (nbt == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        int slot = nbt.func_74762_e("slot");
        IItemHandler capability = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (capability == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        ItemStack stackInSlot = capability.getStackInSlot(slot).func_77946_l();
        if (stackInSlot.func_190926_b()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        IBee bee = BeeManager.beeRoot.getMember(stackInSlot);
        if (bee == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        if (BeeManager.beeRoot.getType(stackInSlot) == EnumBeeType.DRONE) {
            capability.extractItem(slot, 1, false);
        }
        honeyTank.setStorage(Math.max(honeyTank.getStorage() - HONEY_PER_SHOT, 0));
        EntityBeeSwarm swarm = new EntityBeeSwarm(worldIn, BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.QUEEN), (Entity)playerIn);
        Vec3i territory = bee.getGenome().getTerritory();
        float v = (float)(territory.func_177958_n() + territory.func_177956_o() + territory.func_177952_p()) * 0.3f / 24.0f;
        swarm.setAim((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, v, 1.0f);
        worldIn.func_72838_d((Entity)swarm);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void sendSlot(EntityPlayer playerIn, ItemStack heldItem) {
        int invslot;
        for (invslot = 0; invslot < playerIn.field_71071_by.func_70302_i_() && playerIn.field_71071_by.func_70301_a(invslot) != heldItem; ++invslot) {
        }
        if (invslot == playerIn.field_71071_by.func_70302_i_()) {
            throw new IllegalStateException();
        }
        BeeNetworking.net.sendToServer((IMessage)new PacketSlotSelection((byte)this.selectedChamber, invslot));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void hudDraw(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (this.timeout <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack stack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return;
        }
        event.setCanceled(true);
        GuiIngameForge currentScreen = (GuiIngameForge)mc.field_71456_v;
        ScaledResolution resolution = event.getResolution();
        float partialTicks = event.getPartialTicks();
        int x0 = resolution.func_78326_a() / 2;
        int y0 = resolution.func_78328_b() / 2;
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        mc.func_110434_K().func_110577_a(GuiBeeGun.BEEGUN_GUI_TEXTURE);
        currentScreen.func_73729_b(x0 - 35, y0 - 36, 183, 14, 70, 72);
        IItemHandler itemHandler = (IItemHandler)Validate.notNull((Object)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        for (int i = 0; i < 6; ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            GlStateManager.func_179126_j();
            int[] beeCoord = ContainerBeeGun.beeCoords[i];
            int x = beeCoord[0] - 81 + x0 - 17 + 6 + 3;
            int y = beeCoord[1] - 42 + y0 - 18 + 4 + 6;
            mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, stackInSlot, x, y);
            mc.func_175599_af().func_180453_a(currentScreen.func_175179_f(), stackInSlot, x, y, null);
            GlStateManager.func_179140_f();
        }
        if (this.selectedChamber >= 0 && this.selectedChamber < 6) {
            mc.func_110434_K().func_110577_a(GuiBeeGun.BEEGUN_GUI_TEXTURE);
            int[] beeCoord = ContainerBeeGun.beeCoords[this.selectedChamber];
            int x = beeCoord[0] - 81 + x0 - 17;
            int y = beeCoord[1] - 42 + y0 - 17 + 2;
            currentScreen.func_73729_b(x, y, 37, 182, 34, 30);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (this.timeout > 0) {
            --this.timeout;
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) == null) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem != this.curItem && heldItem.func_77973_b() == this) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            this.selectedChamber = tagCompound == null ? 0 : tagCompound.func_74762_e("slot");
        }
        this.curItem = heldItem;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void scroll(@Nonnull MouseEvent event) {
        ItemStack currentItem;
        int k = event.getDwheel();
        if (k == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71462_r != null) {
            return;
        }
        if (mc.field_71474_y.field_74311_E.func_151470_d() && (currentItem = player.field_71071_by.func_70448_g()).func_77973_b() == this) {
            if (k > 0) {
                this.selectedChamber = (this.selectedChamber + 1) % 6;
            } else if (k < 0) {
                --this.selectedChamber;
                if (this.selectedChamber < 0) {
                    this.selectedChamber = 5;
                }
            } else {
                return;
            }
            this.timeout = 120;
            IItemHandler capability = (IItemHandler)currentItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack stackInSlot = capability.getStackInSlot(this.selectedChamber);
            ITextComponent chat = stackInSlot.func_190926_b() ? Lang.chat("Empty", new Object[0]) : stackInSlot.func_151000_E();
            mc.field_71439_g.func_146105_b(chat, true);
            this.sendSlot((EntityPlayer)player, currentItem);
            event.setCanceled(true);
        }
    }

    @Override
    public Container getContainer(EntityPlayer player, ItemStack stack, int slot) {
        return new ContainerBeeGun(player, slot);
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack stack, int slot) {
        return new GuiBeeGun(new ContainerBeeGun(player, slot), player);
    }

    private static class HoneyTank
    extends SimpleFluidTank
    implements IFluidHandlerItem {
        ItemStack stack;

        public HoneyTank(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getStorage() {
            NBTTagCompound nbt = this.stack.func_77978_p();
            return nbt != null ? nbt.func_74762_e("honey") : 0;
        }

        @Override
        public void setStorage(int storage) {
            this.stack.func_77983_a("honey", (NBTBase)new NBTTagInt(storage));
        }

        @Override
        public int getCapacity() {
            return MAX_HONEY;
        }

        @Override
        public Fluid getAllowedFluid() {
            return FluidRegistry.getFluid((String)"for.honey");
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }
    }

    public static class PacketSlotSelection
    extends BeeNetworking.MessageClientToServer {
        byte slot;
        int invslot;

        public PacketSlotSelection() {
        }

        public PacketSlotSelection(byte slot, int invslot) {
            this.slot = slot;
            this.invslot = invslot;
        }

        @Override
        protected void runServer(MessageContext ctx, EntityPlayerMP player) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(this.invslot);
            if (stackInSlot.func_77973_b() == BeeMod.instance.itemBeeGun) {
                stackInSlot.func_77983_a("slot", (NBTBase)new NBTTagByte(this.slot));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.slot = buf.readByte();
            this.invslot = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.slot);
            buf.writeInt(this.invslot);
        }
    }

    private static class BeeStackHandler
    implements IItemHandlerModifiable {
        private ItemStack stack;
        private ItemStackHandler handler = new ItemStackHandler(6){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return BeeManager.beeRoot.isMember(stack) ? stack.func_77976_d() : 0;
            }
        };

        public BeeStackHandler(ItemStack stack) {
            this.stack = stack;
        }

        public int getSlots() {
            return 6;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getHandler().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.save(this.getHandler().insertItem(slot, stack, simulate));
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.save(this.getHandler().extractItem(slot, amount, simulate));
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public <T> T save(T value) {
            NBTTagCompound nbtTagCompound = this.handler.serializeNBT();
            this.stack.func_77983_a("items", (NBTBase)nbtTagCompound);
            return value;
        }

        public ItemStackHandler getHandler() {
            NBTTagCompound tagCompound = this.stack.func_77978_p();
            tagCompound = tagCompound == null ? new NBTTagCompound() : tagCompound.func_74775_l("items");
            this.handler.deserializeNBT(tagCompound);
            return this.handler;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.getHandler().setStackInSlot(slot, stack);
            this.save(null);
        }
    }

    public static class FakeHousingPlayer
    extends FakeHousing {
        final Entity player;
        final BlockPos target;
        final ItemStack queen;

        public FakeHousingPlayer(Entity player, BlockPos target, ItemStack queen) {
            this.player = player;
            this.target = target;
            this.queen = queen;
        }

        @Override
        protected boolean addProduct(@Nonnull ItemStack product, boolean all) {
            float f = 0.5f;
            World world = this.getWorldObj();
            BlockPos pos = this.getCoordinates();
            double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, product.func_77946_l());
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
            return true;
        }

        @Override
        protected ItemStack getQueen() {
            return this.queen;
        }

        @Nonnull
        public World getWorldObj() {
            return this.player.field_70170_p;
        }

        @Nonnull
        public BlockPos getCoordinates() {
            return this.target;
        }
    }
}

