/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.gui;

import com.google.common.collect.ImmutableList;
import com.rwtema.careerbees.bees.CareerBeeSpecies;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.effects.settings.Setting;
import com.rwtema.careerbees.gui.ContainerSettings;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiSettings
extends GuiContainer {
    static final int RIGHT_COLUMN = 166;
    private static final ResourceLocation SETTINGS_GUI_TEXTURE = new ResourceLocation("careerbees", "textures/gui/settings.png");
    private static final int NUM_LINES = 11;
    private static final int START_X = 10;
    private static final int ENTRY_WIDTH = 81;
    @Nonnull
    private final ContainerSettings settings;
    final int offset = 0;
    private final EntityPlayer player;

    public GuiSettings(EntityPlayer player, int slot) {
        super((Container)new ContainerSettings(player, slot));
        this.player = player;
        this.settings = (ContainerSettings)this.field_147002_h;
        this.field_146999_f = 194;
        this.field_147000_g = 219;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void drawStackFromForeground(@Nonnull ItemStack stack, int x, int y) {
        this.drawStackFromForeground(stack, x, y, null);
    }

    public void drawStackFromForeground(@Nonnull ItemStack stack, int x, int y, @Nullable String altText) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SETTINGS_GUI_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            if (this.func_146978_c(169, 17, 16, 16, mouseX, mouseY)) {
                ItemStack itemStack = this.player.field_71071_by.func_70445_o();
                if (itemStack.func_190926_b()) {
                    NBTTagCompound settingsTag = this.getSettingsTag(false);
                    if (settingsTag != null) {
                        settingsTag.func_82580_o("species");
                    }
                    this.settings.sendUpdate();
                } else {
                    IBee member = BeeManager.beeRoot.getMember(itemStack);
                    if (member != null) {
                        NBTTagCompound settingsTag = this.getSettingsTag(true);
                        settingsTag.func_74778_a("species", member.getGenome().getPrimary().getUID());
                        this.settings.sendUpdate();
                    }
                }
                return;
            }
            SettingsEntry[] assignedEntries = this.getAssignedEntries();
            block5: for (int i = 0; i < assignedEntries.length; ++i) {
                SettingsEntry entry = assignedEntries[i];
                if (entry == null) continue;
                int y = 20 + i * 9;
                switch (entry.setting.getType()) {
                    case TEXT: {
                        continue block5;
                    }
                    case BUTTON: {
                        int buttonWidth = entry.getButtonWidth(this);
                        if (!this.func_146978_c(166 - buttonWidth, y + 2, buttonWidth, 14, mouseX, mouseY)) continue block5;
                        Object o1 = entry.setting.nextEntry(entry.value);
                        NBTTagCompound settingsTag = this.getSettingsTag(true);
                        settingsTag.func_74782_a(entry.setting.getKeyname(), entry.setting.toNBT(o1));
                        this.settings.sendUpdate();
                        continue block5;
                    }
                    case ITEMSTACK: {
                        if (!this.func_146978_c(148, y, 18, 18, mouseX, mouseY)) continue block5;
                        Setting setting = entry.setting;
                        ItemStack itemStack = this.player.field_71071_by.func_70445_o();
                        if (setting.isAcceptable(itemStack)) {
                            itemStack = setting.overrideInput(itemStack);
                            Object base = setting.toNBT(itemStack);
                            NBTTagCompound settingsTag = this.getSettingsTag(true);
                            settingsTag.func_74782_a(setting.getKeyname(), base);
                            this.settings.sendUpdate();
                        }
                        return;
                    }
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Nonnull
    public NBTTagCompound getSettingsTag(boolean init) {
        ItemStack stack = this.settings.stack;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            if (!init) {
                return new NBTTagCompound();
            }
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        if (tagCompound.func_150297_b("settings", 10)) {
            return tagCompound.func_74775_l("settings");
        }
        if (!init) {
            return new NBTTagCompound();
        }
        NBTTagCompound value = new NBTTagCompound();
        tagCompound.func_74782_a("settings", (NBTBase)value);
        return value;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(SETTINGS_GUI_TEXTURE);
        this.func_73729_b(169, 36, 240, 0, 16, 15);
        ItemStack stack = this.settings.stack;
        this.field_146289_q.func_78276_b(this.player.field_71071_by.func_145748_c_().func_150260_c(), 8, 126, 0x404040);
        this.field_146289_q.func_78279_b("", 8, 13, 143, -16777216);
        NBTTagCompound settingsTag = this.getSettingsTag(false);
        String speciesName = settingsTag.func_74779_i("species");
        IAllele allele = AlleleManager.alleleRegistry.getAllele(speciesName);
        if (!(allele instanceof IAlleleBeeSpecies) || !CareerBeeSpecies.registeredSpecies.contains(allele)) {
            this.field_146289_q.func_78276_b(stack.func_82833_r(), 8, 6, 0x404040);
            return;
        }
        this.field_146289_q.func_78276_b(stack.func_82833_r() + " - " + allele.getAlleleName(), 8, 6, 0x404040);
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)allele;
        EffectBase effectBase = EffectBase.registeredEffectSpecies.get(species);
        if (effectBase != null) {
            IAllele[] template = BeeManager.beeRoot.getTemplate((IAlleleSpecies)species);
            ItemStack memberStack = BeeManager.beeRoot.getMemberStack((IIndividual)BeeManager.beeRoot.templateAsIndividual(template), (ISpeciesType)EnumBeeType.DRONE);
            this.drawStackFromForeground(memberStack, 169, 17, null);
            SettingsEntry[] assignedEntries = this.getAssignedEntries();
            for (int i = 0; i < assignedEntries.length; ++i) {
                if (assignedEntries[i] == null) continue;
                assignedEntries[i].draw(this, i, 20 + i * 9);
            }
        }
    }

    @Nullable
    IAlleleBeeSpecies getSpecies() {
        String speciesName = this.getSettingsTag(false).func_74779_i("species");
        IAllele allele = AlleleManager.alleleRegistry.getAllele(speciesName);
        if (allele instanceof IAlleleBeeSpecies && CareerBeeSpecies.registeredSpecies.contains(allele)) {
            return (IAlleleBeeSpecies)allele;
        }
        return null;
    }

    @Nullable
    EffectBase getEffect() {
        IAlleleBeeSpecies species = this.getSpecies();
        return species != null ? EffectBase.registeredEffectSpecies.get(species) : null;
    }

    @Nonnull
    SettingsEntryList getEntries() {
        NBTTagCompound settingsTag = this.getSettingsTag(false);
        EffectBase effect = this.getEffect();
        if (effect == null) {
            return new SettingsEntryList((List<SettingsEntry>)ImmutableList.of());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Setting<?, ?> setting : effect.settings) {
            Object o;
            if (settingsTag.func_150297_b(setting.getKeyname(), setting.getExpectedType())) {
                NBTBase tag = settingsTag.func_74781_a(setting.getKeyname());
                o = setting.fromNBT(tag);
            } else {
                o = setting.getDefault();
            }
            builder.add(new SettingsEntry(setting, o));
        }
        return new SettingsEntryList((List<SettingsEntry>)builder.build());
    }

    @Nonnull
    public TIntObjectHashMap<SettingsEntry> getVisibleEntries() {
        SettingsEntryList entries = this.getEntries();
        int n = 0;
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (SettingsEntry entry : entries) {
            if (!entry.setting.shouldBeVisible(entries)) continue;
            map.put(n, (Object)entry);
            n += entry.setting.getType().height;
        }
        return map;
    }

    @Nonnull
    public SettingsEntry[] getAssignedEntries() {
        TIntObjectHashMap<SettingsEntry> visibleEntries = this.getVisibleEntries();
        int startPoint = MathHelper.func_76125_a((int)0, (int)0, (int)Math.max(0, -11));
        SettingsEntry[] settingsEntries = new SettingsEntry[11];
        for (int i = 0; i < 11; ++i) {
            settingsEntries[i] = (SettingsEntry)visibleEntries.get(startPoint + i);
        }
        return settingsEntries;
    }

    public class SettingsEntryList
    implements IEffectSettingsHolder,
    Iterable<SettingsEntry> {
        final List<SettingsEntry> list;

        public SettingsEntryList(List<SettingsEntry> list) {
            this.list = list;
        }

        @Override
        @Nonnull
        public <V> V getValue(@Nonnull Setting<V, ?> setting) {
            return (V)this.list.stream().filter(t -> t.setting == setting).findFirst().map(t -> t.value).orElse(setting.getDefault());
        }

        @Override
        @Nonnull
        public Iterator<SettingsEntry> iterator() {
            return this.list.iterator();
        }
    }

    public static class SettingsEntry<V, NBT extends NBTBase> {
        public final Setting<V, NBT> setting;
        public final V value;
        final Button_State button_state = Button_State.DEFAULT;

        public SettingsEntry(Setting<V, NBT> setting, V value) {
            this.setting = setting;
            this.value = value;
        }

        public void draw(@Nonnull GuiSettings guiSettings, int row, int y) {
            int w;
            List strings = guiSettings.field_146289_q.func_78271_c(this.setting.getKeyname(), 81);
            int height = this.setting.getType().height;
            int color = -2039584;
            if (height == 2 && strings.size() == 1) {
                guiSettings.func_73731_b(guiSettings.field_146289_q, (String)strings.get(0) + ":", 10, y + 4, color);
            } else if (height == 2 && strings.size() >= 2) {
                w = guiSettings.field_146289_q.func_175063_a((String)strings.get(0), 10.0f, (float)y, color);
                w = Math.max(w, guiSettings.field_146289_q.func_175063_a((String)strings.get(1), 10.0f, (float)(y + 9), color));
                guiSettings.field_146289_q.func_175063_a(":", (float)(10 + w), (float)(y + 4), color);
            } else if (height == 1) {
                guiSettings.func_73731_b(guiSettings.field_146289_q, (String)strings.get(0) + ":", 10, y, color);
            }
            switch (this.setting.getType()) {
                case TEXT: {
                    break;
                }
                case BUTTON: {
                    w = this.getButtonWidth(guiSettings);
                    int w2 = w / 2;
                    int texy = this.button_state.index * 14;
                    guiSettings.field_146297_k.func_110434_K().func_110577_a(SETTINGS_GUI_TEXTURE);
                    guiSettings.func_73729_b(166 - w, y + 2, 212, 33 + texy, w2, 14);
                    guiSettings.func_73729_b(166 - w + w2, y + 2, 256 - w2, 33 + texy, w2, 14);
                    if (w > 44) {
                        int dx2;
                        for (int dx = 166 - w + w2; dx < 166 - w + w2 && (dx2 = Math.min(dx + 12, 166 - w + w2)) != dx; dx += 12) {
                            int w3 = dx2 - dx;
                            guiSettings.func_73729_b(dx, y + 2, 244, 75 + texy, w3, 14);
                        }
                    }
                    guiSettings.func_73732_a(guiSettings.field_146289_q, this.setting.format(this.value), 166 - w2, y + 5, this.button_state.textcolor);
                    break;
                }
                case ITEMSTACK: {
                    guiSettings.field_146297_k.func_110434_K().func_110577_a(SETTINGS_GUI_TEXTURE);
                    guiSettings.func_73729_b(148, y, 238, 15, 18, 18);
                    if (!(this.value instanceof ItemStack) || ((ItemStack)this.value).func_190926_b()) break;
                    guiSettings.drawStackFromForeground((ItemStack)this.value, 149, y + 1);
                }
            }
        }

        private int getButtonWidth(@Nonnull GuiSettings guiSettings) {
            return this.setting.getEntries().stream().map(this.setting::format).mapToInt(arg_0 -> ((FontRenderer)guiSettings.field_146289_q).func_78256_a(arg_0)).max().orElseThrow(RuntimeException::new) + 4;
        }
    }

    static enum Button_State {
        DEFAULT(0, -2039584),
        PRESSED(1, -2039584),
        HOVER(2, -96);

        final int index;
        final int textcolor;

        private Button_State(int index, int textcolor) {
            this.index = index;
            this.textcolor = textcolor;
        }
    }
}

