/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects.settings;

import com.google.common.collect.ImmutableSet;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.effects.settings.Setting;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class Filter {
    @Nonnull
    public static final Predicate<ItemStack> DEFAULT_MATCHER = s -> true;
    @Nonnull
    final Setting.Choice<FilterType> filterType;
    @Nonnull
    final Setting.Stack stack;
    @Nonnull
    final Setting.YesNo ignoreMeta;
    @Nonnull
    final Setting.YesNo ignoreNBT;
    @Nonnull
    final Setting.OreDicText oreDicText;

    public Filter(EffectBase parent) {
        this(parent, "Filter");
    }

    public Filter(EffectBase parent, String name) {
        this.filterType = new Setting.Choice<FilterType>(parent, name + "Type", FilterType.ITEMSTACK);
        this.stack = new Setting.Stack(parent, name + "Itemstack"){

            @Override
            public boolean shouldBeVisible(IEffectSettingsHolder settingsHolder) {
                return Filter.this.filterType.getValue(settingsHolder) == FilterType.ITEMSTACK;
            }

            @Override
            @Nonnull
            public ItemStack overrideInput(@Nonnull ItemStack input) {
                if (input.func_190916_E() > 1) {
                    ItemStack copy = input.func_77946_l();
                    copy.func_190920_e(1);
                    return copy;
                }
                return input;
            }
        };
        this.ignoreMeta = new Setting.YesNo(parent, name + "Meta", false){

            @Override
            public boolean shouldBeVisible(IEffectSettingsHolder settingsHolder) {
                return Filter.this.filterType.getValue(settingsHolder) == FilterType.ITEMSTACK;
            }
        };
        this.ignoreNBT = new Setting.YesNo(parent, name + "NBT", true){

            @Override
            public boolean shouldBeVisible(IEffectSettingsHolder settingsHolder) {
                return Filter.this.filterType.getValue(settingsHolder) == FilterType.ITEMSTACK;
            }
        };
        this.oreDicText = new Setting.OreDicText(parent, name + "OreDic"){

            @Override
            public boolean shouldBeVisible(IEffectSettingsHolder settingsHolder) {
                return Filter.this.filterType.getValue(settingsHolder) == FilterType.OREDICTIONARY;
            }
        };
    }

    public boolean matches(@Nonnull IBeeHousing housing, @Nonnull ItemStack stack) {
        for (IBeeModifier modifier : housing.getBeeModifiers()) {
            if (!(modifier instanceof IEffectSettingsHolder)) continue;
            return this.matches((IEffectSettingsHolder)modifier, stack);
        }
        return this.matches(IEffectSettingsHolder.DEFAULT_INSTANCE, stack);
    }

    public boolean matches(IEffectSettingsHolder settings, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        FilterType value = (FilterType)((Object)this.filterType.getValue(settings));
        switch (value) {
            case ITEMSTACK: {
                ItemStack target = (ItemStack)this.stack.getValue(settings);
                return !(target.func_77973_b() != stack.func_77973_b() || (Boolean)this.ignoreMeta.getValue(settings) == false && target.func_77960_j() != stack.func_77960_j() || (Boolean)this.ignoreNBT.getValue(settings) == false && !Objects.equals(target.func_77978_p(), stack.func_77978_p()));
            }
            case OREDICTIONARY: {
                for (ItemStack itemStack : OreDictionary.getOres((String)((String)this.oreDicText.getValue(settings)), (boolean)false)) {
                    if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
                break;
            }
        }
        return true;
    }

    @Nonnull
    public Predicate<ItemStack> getMatcher(IEffectSettingsHolder settings) {
        if (settings == IEffectSettingsHolder.DEFAULT_INSTANCE) {
            return DEFAULT_MATCHER;
        }
        FilterType value = (FilterType)((Object)this.filterType.getValue(settings));
        switch (value) {
            case ITEMSTACK: {
                ItemStack target = (ItemStack)this.stack.getValue(settings);
                return this.createSingleStackPredicate(target, (Boolean)this.ignoreMeta.getValue(settings), (Boolean)this.ignoreNBT.getValue(settings));
            }
            case OREDICTIONARY: {
                Predicate<ItemStack> advPrediacte;
                NonNullList ores = OreDictionary.getOres((String)((String)this.oreDicText.getValue(settings)), (boolean)false);
                if (ores.isEmpty()) {
                    return t -> false;
                }
                if (ores.size() == 1) {
                    ItemStack target;
                    return this.createSingleStackPredicate(target, (target = (ItemStack)ores.get(0)).func_77960_j() == Short.MAX_VALUE, true);
                }
                ImmutableSet basicItems = (ImmutableSet)ores.stream().filter(s -> s.func_77960_j() == Short.MAX_VALUE).map(ItemStack::func_77973_b).collect(ImmutableSet.toImmutableSet());
                Map advItems = ores.stream().filter(s -> s.func_77960_j() != Short.MAX_VALUE).collect(Collectors.groupingBy(ItemStack::func_77973_b, Collectors.mapping(ItemStack::func_77960_j, ImmutableSet.toImmutableSet())));
                Predicate<ItemStack> basicPredicate = basicItems.isEmpty() ? null : s -> basicItems.contains((Object)s.func_77973_b());
                Predicate<ItemStack> predicate = advPrediacte = advItems.isEmpty() ? null : s -> advItems.getOrDefault(s.func_77973_b(), ImmutableSet.of()).contains((Object)s.func_77952_i());
                if (basicPredicate == null) {
                    return advPrediacte == null ? s -> false : advPrediacte;
                }
                if (advPrediacte == null) {
                    return basicPredicate;
                }
                return basicPredicate.and(advPrediacte);
            }
        }
        return s -> false;
    }

    private Predicate<ItemStack> createSingleStackPredicate(@Nonnull ItemStack target, boolean ignoreMetaValue, boolean ignoreNBTValue) {
        if (target.func_190926_b()) {
            return s -> true;
        }
        Item item = target.func_77973_b();
        Predicate<ItemStack> predicate = stack -> stack.func_77973_b() == item;
        if (!ignoreMetaValue) {
            predicate = predicate.and(stack -> stack.func_77960_j() == target.func_77960_j());
        }
        if (!ignoreNBTValue) {
            predicate = predicate.and(stack -> Objects.equals(stack.func_77978_p(), target.func_77978_p()));
        }
        return predicate;
    }

    public static enum FilterType {
        ITEMSTACK,
        OREDICTIONARY;

    }
}

