/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectItemModification;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EffectFoodModify
extends EffectItemModification {
    public static final String BEE_FOOD_NBT = "BEE_FOOD_EFFECTS";
    protected static final HashMap<String, EffectFoodModify> callbacks = new HashMap();

    public EffectFoodModify(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
        callbacks.put(this.getName(), this);
    }

    public EffectFoodModify(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
        callbacks.put(this.getName(), this);
    }

    @SubscribeEvent
    public static void onStartEat(@Nonnull PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getItemStack();
        if (!itemStack.func_190926_b() && itemStack.func_77942_o() && itemStack.func_77973_b() instanceof ItemFood) {
            EntityPlayer entityPlayer = event.getEntityPlayer();
            if (entityPlayer.func_71043_e(false) || !entityPlayer.func_71043_e(true)) {
                return;
            }
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound != null && itemStack.func_77973_b() instanceof ItemFood && tagCompound.func_150297_b(BEE_FOOD_NBT, 10)) {
                NBTTagCompound compoundTag = tagCompound.func_74775_l(BEE_FOOD_NBT);
                for (String s : compoundTag.func_150296_c()) {
                    EffectFoodModify biConsumer = callbacks.get(s);
                    if (biConsumer == null || !biConsumer.shouldBeginEattingOverride(entityPlayer, itemStack, compoundTag.func_74775_l(s))) continue;
                    entityPlayer.func_184598_c(event.getHand());
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTooltip(@Nonnull ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        NBTTagCompound tagCompound = item.func_77978_p();
        if (tagCompound != null && item.func_77973_b() instanceof ItemFood && tagCompound.func_150297_b(BEE_FOOD_NBT, 10) && event.getEntity() instanceof EntityPlayer) {
            NBTTagCompound compoundTag = tagCompound.func_74775_l(BEE_FOOD_NBT);
            for (String s : compoundTag.func_150296_c()) {
                EffectFoodModify biConsumer = callbacks.get(s);
                if (biConsumer == null) continue;
                biConsumer.addTooltip(event.getItemStack(), compoundTag.func_74775_l(s), event.getToolTip());
            }
        }
    }

    @SubscribeEvent
    public static void onFoodEat(@Nonnull LivingEntityUseItemEvent.Finish event) {
        ItemStack item = event.getItem();
        NBTTagCompound tagCompound = item.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b(BEE_FOOD_NBT, 10) && event.getEntity() instanceof EntityPlayer) {
            if (item.func_190926_b()) {
                item = item.func_77946_l();
                item.func_190920_e(1);
            }
            NBTTagCompound compoundTag = tagCompound.func_74775_l(BEE_FOOD_NBT);
            for (String s : compoundTag.func_150296_c()) {
                EffectFoodModify foodModify = callbacks.get(s);
                if (foodModify == null) continue;
                foodModify.callback((EntityPlayer)event.getEntity(), compoundTag.func_74775_l(s), item);
            }
        }
    }

    protected abstract boolean shouldBeginEattingOverride(EntityPlayer var1, ItemStack var2, NBTTagCompound var3);

    @SideOnly(value=Side.CLIENT)
    protected abstract void addTooltip(ItemStack var1, NBTTagCompound var2, List<String> var3);

    public abstract void callback(EntityPlayer var1, NBTTagCompound var2, ItemStack var3);

    @Override
    @Nullable
    public ItemStack modifyStack(IBeeGenome genome, @Nonnull ItemStack stack, IBeeHousing housing) {
        NBTTagCompound prevTag;
        NBTTagCompound newDataTag;
        if (stack.func_77973_b() instanceof ItemFood && (newDataTag = this.addData(genome, stack, prevTag = stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(BEE_FOOD_NBT, 10) && stack.func_77978_p().func_74775_l(BEE_FOOD_NBT).func_150297_b(this.getName(), 10) ? stack.func_77978_p().func_74775_l(BEE_FOOD_NBT).func_74775_l(this.getName()) : null)) != null) {
            ItemStack copy = stack.func_77946_l();
            NBTTagCompound copyTagCompound = copy.func_77978_p();
            if (copyTagCompound == null) {
                copyTagCompound = new NBTTagCompound();
                copy.func_77982_d(copyTagCompound);
            }
            if (!copyTagCompound.func_150297_b(BEE_FOOD_NBT, 10)) {
                copyTagCompound.func_74782_a(BEE_FOOD_NBT, (NBTBase)new NBTTagCompound());
            }
            copyTagCompound.func_74775_l(BEE_FOOD_NBT).func_74782_a(this.getName(), (NBTBase)newDataTag);
            return copy;
        }
        return null;
    }

    @Override
    public boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, ItemStack oldStack, @Nonnull ItemStack newStack, IBeeHousing housing) {
        NBTTagCompound curTag = newStack.func_77978_p().func_74775_l(BEE_FOOD_NBT).func_74775_l(this.getName());
        return this.shouldRelease(genome, frame, curTag);
    }

    protected abstract boolean shouldRelease(IBeeGenome var1, TileFlowerPedastal var2, NBTTagCompound var3);

    @Nullable
    protected abstract NBTTagCompound addData(IBeeGenome var1, ItemStack var2, @Nullable NBTTagCompound var3);

    @Override
    public boolean acceptItemStack(@Nonnull ItemStack stack) {
        NBTTagCompound subTag;
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return false;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b(BEE_FOOD_NBT, 10) && (subTag = tagCompound.func_74775_l(BEE_FOOD_NBT)).func_150297_b(this.getName(), 10)) {
            return this.acceptItemStack(stack, subTag.func_74775_l(this.getName()));
        }
        return this.acceptItemStack(stack, null);
    }

    public abstract boolean acceptItemStack(ItemStack var1, @Nullable NBTTagCompound var2);

    static {
        MinecraftForge.EVENT_BUS.register(EffectFoodModify.class);
    }
}

