/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import gnu.trove.map.hash.TIntByteHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EffectDigging
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectDigging INSTANCE_NORMAL = new EffectDigging(DigType.NORMAL, "miner");
    public static final EffectDigging INSTANCE_SILKY = new EffectDigging(DigType.SILKY, "miner.silky");
    public static final EffectDigging INSTANCE_FORTUNE = new EffectDigging(DigType.FORTUNE, "miner.fortune");
    public static final ThreadLocal<List<ItemStack>> captureStacks = new ThreadLocal();
    final DigType digType;
    final TIntByteHashMap oreIDs = new TIntByteHashMap();

    public EffectDigging(DigType digType, String miner) {
        super(miner, 40.0f);
        this.digType = digType;
    }

    @SubscribeEvent
    public static void captureStacks(@Nonnull EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem) {
            List<ItemStack> stacks = captureStacks.get();
            if (stacks == null) {
                return;
            }
            stacks.add(((EntityItem)event.getEntity()).func_92059_d());
            event.setCanceled(true);
        }
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random rand, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectDigging.getAABB(genome, housing);
        int x0 = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int x1 = MathHelper.func_76143_f((double)aabb.field_72336_d);
        int z0 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int z1 = MathHelper.func_76143_f((double)aabb.field_72334_f);
        if (x1 <= x0 || z1 <= z0) {
            return;
        }
        BlockPos.PooledMutableBlockPos pooledBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 80; ++i) {
            pooledBlockPos.func_181079_c(x0 + rand.nextInt(x1 - x0), 0, z0 + rand.nextInt(z1 - z0));
            pooledBlockPos.func_185336_p(rand.nextInt(world.func_175726_f((BlockPos)pooledBlockPos).func_76625_h() + 16));
            this.processPosition(housing, world, (BlockPos)pooledBlockPos);
        }
    }

    public boolean processPosition(@Nonnull IBeeHousing housing, @Nonnull World world, @Nonnull BlockPos pooledBlockPos) {
        IBlockState blockState = world.func_180495_p(pooledBlockPos);
        Block block = blockState.func_177230_c();
        if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pooledBlockPos)) {
            return false;
        }
        ItemStack item = blockState.func_177230_c().getPickBlock(blockState, new RayTraceResult(new Vec3d((Vec3i)pooledBlockPos), EnumFacing.DOWN, pooledBlockPos), world, pooledBlockPos, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        if (item.func_190926_b()) {
            return false;
        }
        boolean isOre = this.isOre(item);
        return isOre && this.digPosition(housing, world, pooledBlockPos, blockState, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean digPosition(@Nonnull IBeeHousing housing, @Nonnull World world, @Nonnull BlockPos pooledBlockPos, IBlockState blockState, Block block) {
        products = new ArrayList<E>();
        try {
            EffectDigging.captureStacks.set(products);
            switch (1.$SwitchMap$com$rwtema$careerbees$effects$EffectDigging$DigType[this.digType.ordinal()]) {
                case 1: {
                    block.func_176226_b(world, pooledBlockPos, blockState, 0);
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    block.func_176226_b(world, pooledBlockPos, blockState, 2);
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 3: {
                    fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                    stack = new ItemStack(Items.field_151046_w);
                    stack.func_77966_a(Enchantments.field_185306_r, 1);
                    block.func_180657_a(world, (EntityPlayer)fakePlayer, pooledBlockPos, blockState, world.func_175625_s(pooledBlockPos), stack);
                    break;
                }
                ** default:
lbl20:
                // 1 sources

                break;
            }
        }
        finally {
            EffectDigging.captureStacks.set(null);
        }
        addedSomething = false;
        iterator = products.iterator();
        while (iterator.hasNext()) {
            product = (ItemStack)iterator.next();
            if (product.func_190926_b()) {
                iterator.remove();
                continue;
            }
            remainder = EffectDigging.tryAdd(product, housing.getBeeInventory());
            addedSomething |= remainder.func_190916_E() != product.func_190916_E();
            if (remainder.func_190926_b()) {
                iterator.remove();
                continue;
            }
            product.func_190920_e(remainder.func_190916_E());
        }
        world.func_175718_b(2001, pooledBlockPos, Block.func_176210_f((IBlockState)blockState));
        world.func_175698_g(pooledBlockPos);
        for (ItemStack product : products) {
            Block.func_180635_a((World)world, (BlockPos)pooledBlockPos, (ItemStack)product);
        }
        return true;
    }

    private boolean isOre(@Nonnull ItemStack item) {
        for (int oreID : OreDictionary.getOreIDs((ItemStack)item)) {
            byte b = this.oreIDs.get(oreID);
            if (b == 1) continue;
            if (b == 2) {
                return true;
            }
            String oreName = OreDictionary.getOreName((int)oreID);
            if (this.hasOrePrefix(oreName, "ore") || this.hasOrePrefix(oreName, "denseore")) {
                this.oreIDs.put(oreID, (byte)2);
                return true;
            }
            this.oreIDs.put(oreID, (byte)1);
        }
        return false;
    }

    private boolean hasOrePrefix(@Nonnull String oreName, @Nonnull String prefix) {
        return oreName.length() > prefix.length() && oreName.startsWith(prefix) && Character.isUpperCase(oreName.charAt(prefix.length()));
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        return true;
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        IBlockState blockState = world.func_180495_p(pos);
        return this.digPosition(housing, world, pos, blockState, blockState.func_177230_c());
    }

    static {
        MinecraftForge.EVENT_BUS.register(EffectDigging.class);
    }

    public static enum DigType {
        NORMAL,
        FORTUNE,
        SILKY;

    }
}

