/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseEntity;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class EffectDairy
extends EffectBaseEntity<EntityCow> {
    public EffectDairy(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing, ((Predicate<EntityCow>)arg_0 -> ((com.google.common.base.Predicate)EntitySelectors.field_94557_a).apply(arg_0)).and(t -> !t.func_70631_g_()), EntityCow.class);
    }

    @Override
    protected void workOnEntities(@Nonnull List<EntityCow> entities, IBeeGenome genome, @Nonnull IBeeHousing housing, Random random, IEffectSettingsHolder settings) {
        Fluid milk = FluidRegistry.getFluid((String)"milk");
        if (milk == null) {
            return;
        }
        WorldServer worldObj = (WorldServer)housing.getWorldObj();
        List fluidHandlers = this.getAdjacentCapabilities(housing, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (fluidHandlers.isEmpty()) {
            return;
        }
        for (EntityCow cow : entities) {
            if (cow.getClass() == EntityCow.class) {
                FluidStack fluidStack = new FluidStack(milk, 1000);
                for (IFluidHandler handler : fluidHandlers) {
                    int fill = handler.fill(fluidStack, false);
                    fluidStack.amount -= fill;
                    if (fluidStack.amount != 0) continue;
                    break;
                }
                if (fluidStack.amount != 0) {
                    return;
                }
            }
            FakePlayer minecraft = FakePlayerFactory.getMinecraft((WorldServer)worldObj);
            minecraft.field_71075_bZ.field_75098_d = false;
            minecraft.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
            cow.func_184645_a((EntityPlayer)minecraft, EnumHand.MAIN_HAND);
            ItemStack heldItem = minecraft.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
            minecraft.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            FluidStack fluidContained = FluidUtil.getFluidContained((ItemStack)heldItem);
            if (fluidContained == null && heldItem.func_77973_b() == Items.field_151117_aB) {
                fluidContained = new FluidStack(milk, 1000);
            }
            if (fluidContained != null && fluidContained.amount > 0) {
                for (IFluidHandler fluidHandler : fluidHandlers) {
                    fluidContained.amount -= fluidHandler.fill(fluidContained, true);
                    if (fluidContained.amount > 0) continue;
                    break;
                }
                if (fluidContained.amount > 1000) {
                    // empty if block
                }
            }
            heldItem.func_190920_e(0);
        }
    }
}

