/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.ComparisonChain;
import com.rwtema.careerbees.blocks.BlockFlowerPedastal;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.helpers.ParticleHelper;
import com.rwtema.careerbees.recipes.BeeCraftingInputEntry;
import com.rwtema.careerbees.recipes.BeeCraftingRecipe;
import com.rwtema.careerbees.recipes.IBeeCraftingRecipe;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class EffectCrafting
extends EffectBaseThrottled {
    @Nonnull
    public static final EffectCrafting INSTANCE = new EffectCrafting();

    public EffectCrafting() {
        super("crafting", true, false, 20.0f, 1.0f);
    }

    @Nonnull
    public static List<TileFlowerPedastal> getPlantFrames(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d territory, @Nonnull IBeeGenome genome) {
        ArrayList<TileFlowerPedastal> craftingUnits = new ArrayList<TileFlowerPedastal>();
        int x_min = MathHelper.func_76128_c((double)((double)pos.func_177958_n() - territory.field_72450_a));
        int x_max = MathHelper.func_76143_f((double)((double)pos.func_177958_n() + territory.field_72450_a));
        int y_min = MathHelper.func_76128_c((double)((double)pos.func_177956_o() - territory.field_72448_b));
        int y_max = MathHelper.func_76143_f((double)((double)pos.func_177956_o() + territory.field_72448_b));
        int z_min = MathHelper.func_76128_c((double)((double)pos.func_177952_p() - territory.field_72449_c));
        int z_max = MathHelper.func_76143_f((double)((double)pos.func_177952_p() + territory.field_72449_c));
        for (int chunk_x = x_min >> 4; chunk_x <= x_max >> 4; ++chunk_x) {
            for (int chunk_z = z_min >> 4; chunk_z <= z_max >> 4; ++chunk_z) {
                Chunk chunk = world.func_72964_e(chunk_x, chunk_z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    TileFlowerPedastal frame;
                    TileEntity tileEntity;
                    BlockPos key = (BlockPos)entry.getKey();
                    if (key.func_177958_n() < x_min || key.func_177958_n() > x_max || key.func_177956_o() < y_min || key.func_177956_o() > y_max || key.func_177952_p() < z_min || key.func_177952_p() > z_max || !((tileEntity = (TileEntity)entry.getValue()) instanceof TileFlowerPedastal) || !(frame = (TileFlowerPedastal)tileEntity).hasStack() || !frame.accepts(genome)) continue;
                    craftingUnits.add(frame);
                }
            }
        }
        return craftingUnits;
    }

    @Override
    @Nonnull
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        Vec3d territory;
        BlockPos pos;
        World world = housing.getWorldObj();
        Pair<ItemStack, ArrayList<TileFlowerPedastal>> result = this.getCraftingResult(world, pos = housing.getCoordinates(), territory = EffectCrafting.getTerritory(genome, housing), genome);
        if (result == null) {
            return super.doFX(genome, storedData, housing);
        }
        ArrayList<BlockPos> flowerPos = new ArrayList<BlockPos>();
        for (TileFlowerPedastal tileFlowerPedastal : (ArrayList)result.getRight()) {
            BlockPos blockPos = tileFlowerPedastal.func_174877_v();
            flowerPos.add(blockPos);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)blockPos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)blockPos.func_177956_o() + world.field_73012_v.nextFloat()), (double)((float)blockPos.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
        ParticleHelper.BEE_HIVE_FX.addBeeHiveFX(housing, genome, flowerPos);
        return storedData;
    }

    @Override
    public boolean canAcceptItems() {
        return true;
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, @Nonnull BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        Vec3d territory = EffectCrafting.getTerritory(genome, housing);
        Pair<ItemStack, ArrayList<TileFlowerPedastal>> result = this.getCraftingResult(world, pos, territory, genome);
        if (result != null) {
            ItemStack output = (ItemStack)result.getLeft();
            if (!output.func_190926_b() && housing.getBeeInventory().addProduct(output, true)) {
                for (TileFlowerPedastal tile : (ArrayList)result.getRight()) {
                    BlockFlowerPedastal.sendPulse(tile, BlockFlowerPedastal.ParticleType.YELLOW);
                    tile.setStack(ForgeHooks.getContainerItem((ItemStack)tile.getStack()));
                    world.func_184138_a(tile.func_174877_v(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 0);
                }
            }
        } else {
            storedData.setInteger(0, 0);
        }
    }

    @Nullable
    private Pair<ItemStack, ArrayList<TileFlowerPedastal>> getCraftingResult(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d territory, @Nonnull IBeeGenome genome) {
        List units;
        List<TileFlowerPedastal> craftingUnits = EffectCrafting.getPlantFrames(world, pos, territory, genome);
        Pair result = null;
        HashMap<BeeCraftingInputEntry, ItemStack> stacks = new HashMap<BeeCraftingInputEntry, ItemStack>();
        if (!craftingUnits.isEmpty() && (units = craftingUnits.stream().sorted((o1, o2) -> {
            BlockPos pos1 = o1.func_174877_v();
            BlockPos pos2 = o2.func_174877_v();
            return ComparisonChain.start().compare(pos1.func_177951_i((Vec3i)pos), pos2.func_177951_i((Vec3i)pos)).compare(pos1.func_177958_n(), pos2.func_177958_n()).compare(pos1.func_177952_p(), pos2.func_177952_p()).compare(pos2.func_177956_o(), pos1.func_177956_o()).result();
        }).collect(Collectors.toList())).size() > 0) {
            IBeeCraftingRecipe recipe;
            List<BeeCraftingInputEntry> inputs;
            BitSet bitSet = new BitSet(units.size());
            Iterator<IBeeCraftingRecipe> iterator = BeeCraftingRecipe.RECIPES.iterator();
            block0: while (iterator.hasNext() && (inputs = (recipe = iterator.next()).getInputs()).size() <= units.size()) {
                ArrayList<TileFlowerPedastal> tiles = new ArrayList<TileFlowerPedastal>();
                stacks.clear();
                bitSet.clear();
                block1: for (BeeCraftingInputEntry input : inputs) {
                    for (int i = 0; i < units.size(); ++i) {
                        TileFlowerPedastal tileFlowerPedastal;
                        ItemStack stack;
                        if (bitSet.get(i) || !input.test(stack = (tileFlowerPedastal = (TileFlowerPedastal)((Object)units.get(i))).getStack())) continue;
                        bitSet.set(i);
                        stacks.put(input, stack);
                        tiles.add(tileFlowerPedastal);
                        continue block1;
                    }
                    continue block0;
                }
                result = Pair.of((Object)recipe.getOutput(stacks), tiles);
                break;
            }
        }
        return result;
    }
}

