/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.blocks;

import com.rwtema.careerbees.bees.CareerBeeEntry;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.helpers.NBTSerializer;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFlowerPedastal
extends TileEntity {
    public static final HashMap<String, Predicate<ItemStack>> EFFECT_PREDICATE_MAP = new HashMap();
    public static final NBTSerializer<TileFlowerPedastal> serializer = NBTSerializer.getTileEntitySeializer(TileFlowerPedastal.class).addItemStack("stack", TileFlowerPedastal::getStack, TileFlowerPedastal::setStack).addBoolean("canExtract", p -> p.canExtract, (p, s) -> {
        p.canExtract = s;
    }).addString("speciesType", p -> p.speciesType, (p, s) -> {
        p.speciesType = s;
    });
    public static final NBTSerializer<TileFlowerPedastal> updateTagSerializer = serializer.getPartial("stack", "speciesType");
    boolean canExtract = false;
    String speciesType = "";
    @Nullable
    final ItemStackHandler stackHandler = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            if (TileFlowerPedastal.this.canAcceptStack(stack)) {
                return super.getStackLimit(slot, stack);
            }
            return 0;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!TileFlowerPedastal.this.canExtract && (TileFlowerPedastal.this.speciesType.isEmpty() || TileFlowerPedastal.this.getStack().func_190926_b() || TileFlowerPedastal.this.canAcceptStack(TileFlowerPedastal.this.getStack()))) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (TileFlowerPedastal.this.canExtract && ((ItemStack)this.stacks.get(0)).func_190926_b()) {
                TileFlowerPedastal.this.canExtract = false;
            }
            if (TileFlowerPedastal.this.field_145850_b != null) {
                TileFlowerPedastal.this.func_70296_d();
                BlockPos pos = TileFlowerPedastal.this.func_174877_v();
                IBlockState blockState = TileFlowerPedastal.this.field_145850_b.func_180495_p(pos);
                TileFlowerPedastal.this.field_145850_b.func_184138_a(pos, blockState, blockState, 0);
            }
        }
    };

    public boolean canAcceptStack(@Nonnull ItemStack stack) {
        return EFFECT_PREDICATE_MAP.computeIfAbsent(this.speciesType, s -> {
            IAlleleBeeEffect effect;
            IAlleleBeeSpecies species = CareerBeeEntry.CustomBeeFactory.STRING_SPECIES_MAP.get(this.speciesType);
            if (species != null && (effect = CareerBeeEntry.CustomBeeFactory.SPECIES_EFFECT_MAP.get(species)) instanceof EffectBase) {
                return ((EffectBase)effect)::acceptItemStack;
            }
            return i -> true;
        }).test(stack);
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stackHandler.getStackInSlot(0);
    }

    public void setStack(@Nonnull ItemStack stack) {
        this.stackHandler.setStackInSlot(0, stack);
    }

    public boolean hasStack() {
        return !this.getStack().func_190926_b();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.stackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        updateTagSerializer.readFromNBT(this, tag);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        updateTagSerializer.writeToNBT(this, updateTag);
        return updateTag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        serializer.readFromNBT(this, compound);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbtTagCompound = super.func_189515_b(compound);
        serializer.writeToNBT(this, nbtTagCompound);
        return nbtTagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public void setShouldRelease() {
        this.canExtract = true;
    }

    public boolean accepts(@Nonnull IBeeGenome genome) {
        return this.speciesType.isEmpty() || this.speciesType.equals(genome.getPrimary().getUID());
    }
}

