/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import com.rwtema.careerbees.ClientRunnable;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.core.IModelManager;
import forestry.api.genetics.AlleleManager;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class CustomBeeModel
implements IBeeModelProvider {
    public static final Set<String> SUFFIXES = new HashSet<String>();
    public static BiConsumer<String, CustomBeeModel> modelCreationHook;
    @SideOnly(value=Side.CLIENT)
    private static IAlleleBeeSpecies throwback;
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation drone_location;
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation queen_location;
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation princess_location;
    public final String suffix;
    public final boolean background;

    public CustomBeeModel(String suffix) {
        this(suffix, false);
    }

    public CustomBeeModel(final String suffix, boolean background) {
        this.suffix = suffix;
        this.background = background;
        SUFFIXES.add(suffix);
        ClientRunnable.safeRun(new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                CustomBeeModel.this.drone_location = CustomBeeModel.this.modelLocation("drone", suffix);
                CustomBeeModel.this.queen_location = CustomBeeModel.this.modelLocation("queen", suffix);
                CustomBeeModel.this.princess_location = CustomBeeModel.this.modelLocation("princess", suffix);
                CustomBeeModel.registerModels(suffix);
            }
        });
        if (modelCreationHook != null) {
            modelCreationHook.accept(suffix, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(String suffix) {
        CustomBeeModel.doRegister(suffix, "queen", "bee_queen_ge");
        CustomBeeModel.doRegister(suffix, "princess", "bee_princess_ge");
        CustomBeeModel.doRegister(suffix, "drone", "bee_drone_ge");
    }

    private static void doRegister(String suffix, String queen, @Nonnull String bee_queen_ge) {
        ModelBakery.registerItemVariants((Item)((Item)Validate.notNull((Object)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("forestry", bee_queen_ge)))), (ResourceLocation[])new ResourceLocation[]{CustomBeeModel.resourceLocation(queen, suffix)});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation resourceLocation(String name, String mining) {
        return new ResourceLocation("careerbees:bees/" + name + "_" + mining);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation modelLocation(String name, String mining) {
        return new ModelResourceLocation("careerbees:bees/" + name + "_" + mining, "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(@Nonnull Item item, @Nonnull IModelManager manager) {
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(@Nonnull EnumBeeType type) {
        switch (type) {
            case DRONE: {
                return this.drone_location;
            }
            case QUEEN: {
                return this.queen_location;
            }
            case PRINCESS: {
                return this.princess_location;
            }
        }
        if (throwback == null) {
            throwback = (IAlleleBeeSpecies)Validate.notNull((Object)((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesForest")));
        }
        return throwback.getModel(type);
    }
}

