/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.AlleleTemplate;
import com.rwtema.careerbees.bees.BeeMutationTree;
import com.rwtema.careerbees.bees.CareerBeeSpecies;
import com.rwtema.careerbees.bees.CustomBeeModel;
import com.rwtema.careerbees.colors.DebugBeeSpriteColors;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.helpers.StringHelper;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBeeModelProvider;
import forestry.api.apiculture.IBeeSpriteColourProvider;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CareerBeeEntry
implements Supplier<IAlleleBeeSpecies>,
BeeMutationTree.SpeciesEntry {
    public static final List<CareerBeeEntry> BEE_ENTRIES = new ArrayList<CareerBeeEntry>();
    final List<Consumer<CustomBeeFactory>> speciesInstructions = new ArrayList<Consumer<CustomBeeFactory>>();
    private final String name;
    private final boolean dominant;
    private final String branchName;
    private final int primaryColor;
    private final int secondaryColor;
    public IAlleleBeeSpecies species;
    public String modelName;
    boolean shouldAddVanillaProducts = true;
    private boolean isSecret;

    public CareerBeeEntry(String name, boolean dominant, String branchName, int primaryColor) {
        this(name, dominant, branchName, primaryColor, 16768022);
    }

    public CareerBeeEntry(String name, boolean dominant, String branchName, int primaryColor, int secondaryColor) {
        BEE_ENTRIES.add(this);
        this.name = name;
        this.dominant = dominant;
        this.branchName = branchName;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.modelName = name;
    }

    public static float roundSig(float k, float n) {
        if (k <= 0.0f || n <= 0.0f) {
            return 0.0f;
        }
        if (k < 1.0f) {
            return CareerBeeEntry.roundSig(k * n, n) / n;
        }
        return Math.round(k);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CareerBeeEntry)) {
            return false;
        }
        CareerBeeEntry that = (CareerBeeEntry)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Nonnull
    public String toString() {
        return "CareerBeeEntry{name='" + this.name + '\'' + '}';
    }

    @Nonnull
    public final CareerBeeEntry setTemperature(@Nonnull EnumTemperature temperature) {
        this.speciesInstructions.add(c -> c.setTemperature(temperature));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setHumidity(@Nonnull EnumHumidity humidity) {
        this.speciesInstructions.add(c -> c.setHumidity(humidity));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setHasEffect() {
        this.speciesInstructions.add(IAlleleSpeciesBuilder::setHasEffect);
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setIsSecret() {
        this.speciesInstructions.add(IAlleleSpeciesBuilder::setIsSecret);
        this.isSecret = true;
        return this;
    }

    public final boolean isSecret() {
        return this.isSecret;
    }

    @Nonnull
    public final CareerBeeEntry setIsNotCounted() {
        this.speciesInstructions.add(CustomBeeFactory::setIsNotCounted);
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setComplexity(int complexity) {
        this.speciesInstructions.add(c -> c.setComplexity(complexity));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry addProduct(@Nonnull ItemStack product, @Nonnull Float chance) {
        this.speciesInstructions.add(c -> c.addProduct(product, chance));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry addSpecialty(@Nonnull ItemStack specialty, @Nonnull Float chance) {
        this.speciesInstructions.add(c -> c.addSpecialty(specialty, chance));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setJubilanceProvider(@Nonnull IJubilanceProvider provider) {
        this.speciesInstructions.add(c -> c.setJubilanceProvider(provider));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setNocturnal() {
        this.speciesInstructions.add(IAlleleBeeSpeciesBuilder::setNocturnal);
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setCustomBeeModelProvider(IBeeModelProvider beeIconProvider) {
        if (beeIconProvider instanceof CustomBeeModel) {
            this.modelName = ((CustomBeeModel)beeIconProvider).suffix;
        }
        this.speciesInstructions.add(c -> c.setCustomBeeModelProvider(beeIconProvider));
        return this;
    }

    public final CareerBeeEntry removeVanillaProducts() {
        this.shouldAddVanillaProducts = false;
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setCustomBeeSpriteColourProvider(@Nonnull IBeeSpriteColourProvider beeIconColourProvider) {
        this.speciesInstructions.add(c -> c.setCustomBeeSpriteColourProvider(beeIconColourProvider));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setTemplateAllelleBool(@Nonnull EnumBeeChromosome effect, boolean val) {
        return this.setTemplateAllelleString(effect, val ? "forestry.boolTrue" : "forestry.boolFalse");
    }

    @Nonnull
    public final CareerBeeEntry setTemplateAllelleString(@Nonnull EnumBeeChromosome effect, String value) {
        this.speciesInstructions.add(c -> c.setTemplateAllelle(effect, value));
        return this;
    }

    @Nonnull
    public final CareerBeeEntry setTemplateEffect(@Nonnull Supplier<? extends EffectBase> supplier) {
        return this.setTemplate(EnumBeeChromosome.EFFECT, supplier);
    }

    @Nonnull
    public final CareerBeeEntry setTemplate(@Nonnull EnumBeeChromosome effect, @Nonnull Supplier<? extends IAllele> supplier) {
        this.speciesInstructions.add(c -> c.setTemplateAllelle(effect, supplier.get()));
        return this;
    }

    public final void build() {
        CustomBeeFactory beeFactory = CustomBeeFactory.factory(this.name, this.dominant, this.branchName, this.primaryColor, this.secondaryColor);
        this.speciesInstructions.forEach(c -> c.accept(beeFactory));
        if (this.shouldAddVanillaProducts) {
            this.addVanillaProducts(beeFactory);
        }
        this.species = beeFactory.build();
    }

    private void addVanillaProducts(@Nonnull CustomBeeFactory beeFactory) {
        List<BeeMutationTree.SpeciesEntry> vanillaParents = CareerBeeSpecies.tree.getVanillaParents(this);
        HashMap<ItemStack, Pair> sumMap = new HashMap<ItemStack, Pair>();
        for (BeeMutationTree.SpeciesEntry speciesEntry : vanillaParents) {
            Map productChances = ((IAlleleBeeSpecies)speciesEntry.get()).getProductChances();
            block1: for (Map.Entry inEntry : productChances.entrySet()) {
                for (Map.Entry entry : sumMap.entrySet()) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)entry.getKey()), (ItemStack)((ItemStack)inEntry.getKey()))) continue;
                    entry.setValue(Pair.of((Object)Float.valueOf(((Float)inEntry.getValue()).floatValue() + ((Float)((Pair)entry.getValue()).getLeft()).floatValue()), (Object)Float.valueOf(Math.max(((Float)inEntry.getValue()).floatValue(), ((Float)((Pair)entry.getValue()).getRight()).floatValue()))));
                    continue block1;
                }
                sumMap.put(((ItemStack)inEntry.getKey()).func_77946_l(), Pair.of(inEntry.getValue(), inEntry.getValue()));
            }
        }
        for (Map.Entry entry : sumMap.entrySet()) {
            Float maxChance;
            float meanChance = ((Float)((Pair)entry.getValue()).getLeft()).floatValue() / (float)vanillaParents.size();
            float finalChance = (meanChance + (maxChance = (Float)((Pair)entry.getValue()).getRight()).floatValue()) / 2.0f;
            float chance = CareerBeeEntry.roundSig(finalChance, 20.0f);
            if (!(chance > 0.0f)) continue;
            beeFactory.addProduct((ItemStack)entry.getKey(), Float.valueOf(chance));
        }
    }

    @Override
    public final IAlleleBeeSpecies get() {
        return this.species;
    }

    public void preInit() {
    }

    public void init() {
    }

    @Override
    public boolean isVanilla() {
        return false;
    }

    @Nonnull
    public String getAlleleName() {
        return this.species.getAlleleName();
    }

    public static class CustomBeeFactory
    implements IAlleleBeeSpeciesBuilder {
        public static final HashMap<IAlleleBeeSpecies, IAlleleBeeEffect> SPECIES_EFFECT_MAP = new HashMap();
        public static final HashMap<String, IAlleleBeeSpecies> STRING_SPECIES_MAP = new HashMap();
        static final HashSet<String> assignedUUIDs = new HashSet();
        final IAlleleBeeSpeciesBuilder species;
        @Nonnull
        final AlleleTemplate template;
        final List<Pair<ItemStack, Float>> products = new ArrayList<Pair<ItemStack, Float>>();

        public CustomBeeFactory(IAlleleBeeSpeciesBuilder species) {
            this.species = species;
            this.template = AlleleTemplate.createAlleleTemplate(null);
        }

        @Nonnull
        public static CustomBeeFactory factory(String name, boolean dominant, String branchName, int primaryColor) {
            return CustomBeeFactory.factory(name, dominant, branchName, primaryColor, 16768022);
        }

        @Nonnull
        public static CustomBeeFactory factory(String name, boolean dominant, String branchName, int primaryColor, int secondaryColor) {
            branchName = new ResourceLocation("careerbees", new ResourceLocation(branchName).func_110623_a()).toString();
            IClassification branch = CareerBeeSpecies.classificationHashMap.computeIfAbsent(branchName, s -> {
                ResourceLocation resourceLocation = new ResourceLocation(s);
                IClassification classification = BeeManager.beeFactory.createBranch(resourceLocation.func_110623_a(), resourceLocation.func_110624_b());
                AlleleManager.alleleRegistry.getClassification("family.apidae").addMemberGroup(classification);
                return classification;
            });
            String uid = "careerbees." + name;
            if (!assignedUUIDs.add(uid)) {
                throw new IllegalStateException(uid + " is already registered");
            }
            String speciesKey = "careerbees.bees.species." + uid;
            String speciesDescKey = "careerbees.description." + uid;
            String speciesBinomKey = "careerbees.bees.binomial.species." + uid;
            if (BeeMod.deobf_folder) {
                String s2 = StringHelper.capFirstMulti(name);
                Lang.translate(speciesKey, s2);
                Lang.translate(speciesDescKey, s2 + " Description");
                Lang.translate(speciesBinomKey, s2);
            }
            IAlleleBeeSpeciesBuilder species = BeeManager.beeFactory.createSpecies("careerbees", uid, dominant, "RWTema", speciesKey, speciesDescKey, branch, speciesBinomKey, primaryColor, secondaryColor);
            if (BeeMod.deobf) {
                species.setCustomBeeSpriteColourProvider((IBeeSpriteColourProvider)new DebugBeeSpriteColors(primaryColor, secondaryColor));
            }
            return new CustomBeeFactory(species);
        }

        @Nonnull
        public CustomBeeFactory setTemplateAllelle(@Nonnull EnumBeeChromosome chromosome, Object value) {
            this.template.setTemplateAllelle(chromosome, value);
            return this;
        }

        @Nonnull
        public IAlleleBeeSpecies build() {
            this.products.forEach(pair -> this.species.addProduct((ItemStack)pair.getKey(), (Float)pair.getValue()));
            IAlleleBeeSpecies species = this.species.build();
            IAlleleBeeEffect effect = this.template.getEffect();
            if (effect instanceof EffectBase) {
                ((EffectBase)effect).addSpecies(species);
            }
            this.template.setTemplateAllelle(EnumBeeChromosome.SPECIES, species);
            this.template.register();
            STRING_SPECIES_MAP.put(species.getUID(), species);
            SPECIES_EFFECT_MAP.put(species, this.template.getEffect());
            return species;
        }

        @Nonnull
        public CustomBeeFactory addProduct(@Nonnull ItemStack product, @Nonnull Float chance) {
            this.products.add((Pair<ItemStack, Float>)Pair.of((Object)product, (Object)chance));
            return this;
        }

        @Nonnull
        public CustomBeeFactory addSpecialty(@Nonnull ItemStack specialty, @Nonnull Float chance) {
            this.species.addSpecialty(specialty, chance);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setJubilanceProvider(@Nonnull IJubilanceProvider provider) {
            this.species.setJubilanceProvider(provider);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setNocturnal() {
            this.species.setNocturnal();
            return this;
        }

        @Nonnull
        public CustomBeeFactory setCustomBeeModelProvider(@Nonnull IBeeModelProvider beeIconProvider) {
            this.species.setCustomBeeModelProvider(beeIconProvider);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setCustomBeeSpriteColourProvider(@Nonnull IBeeSpriteColourProvider beeIconColourProvider) {
            this.species.setCustomBeeSpriteColourProvider(beeIconColourProvider);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setTemperature(@Nonnull EnumTemperature temperature) {
            this.species.setTemperature(temperature);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setHumidity(@Nonnull EnumHumidity humidity) {
            this.species.setHumidity(humidity);
            return this;
        }

        @Nonnull
        public CustomBeeFactory setHasEffect() {
            this.species.setHasEffect();
            return this;
        }

        @Nonnull
        public CustomBeeFactory setIsSecret() {
            this.species.setIsSecret();
            this.setIsNotCounted();
            return this;
        }

        @Nonnull
        public CustomBeeFactory setIsNotCounted() {
            this.species.setIsNotCounted();
            return this;
        }

        public void setComplexity(int complexity) {
            this.species.setComplexity(complexity);
        }

        @Nonnull
        public CustomBeeFactory setComplexityRet(int complexity) {
            this.setComplexity(complexity);
            return this;
        }

        @Nonnull
        public CustomBeeFactory clearDefaultProducts() {
            this.products.clear();
            return this;
        }
    }
}

