/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.client.gui2.tasks.PanelTaskRetrieval;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskRetrieval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskRetrieval
implements ITask,
IProgression<int[]>,
IItemTask,
ITaskTickable {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public ArrayList<BigItemStack> requiredItems = new ArrayList();
    public HashMap<UUID, int[]> userProgress = new HashMap();
    boolean partialMatch = true;
    boolean ignoreNBT = false;
    public boolean consume = true;
    public boolean idvDetect = true;
    public boolean autoConsume = false;

    public String getUnlocalisedName() {
        return "bq_standard.task.retrieval";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskRetrieval.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    @Override
    public void tickTask(IQuest quest, EntityPlayer player) {
        if (player.field_70173_aa % 60 == 0 && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            if (!this.consume || this.autoConsume) {
                this.detect(player, quest);
            } else {
                boolean flag = true;
                int[] totalProgress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(QuestingAPI.getQuestingUUID((EntityPlayer)player)) : this.getGlobalProgress();
                for (int j = 0; j < this.requiredItems.size(); ++j) {
                    BigItemStack rStack = this.requiredItems.get(j);
                    if (rStack == null || totalProgress[j] >= rStack.stackSize) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    this.setComplete(QuestingAPI.getQuestingUUID((EntityPlayer)player));
                }
            }
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        BigItemStack rStack;
        int i;
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (player.field_71071_by == null || this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            for (int j = 0; j < this.requiredItems.size() && (stack = player.field_71071_by.func_70301_a(i)) != null; ++j) {
                rStack = this.requiredItems.get(j);
                if (rStack == null || progress[j] >= rStack.stackSize) continue;
                int remaining = rStack.stackSize - progress[j];
                if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((String)rStack.oreDict, (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
                if (this.consume) {
                    ItemStack removed = player.field_71071_by.func_70298_a(i, remaining);
                    int n = j;
                    progress[n] = progress[n] + removed.func_190916_E();
                    continue;
                }
                int n = j;
                progress[n] = progress[n] + Math.min(remaining, stack.func_190916_E());
            }
        }
        if (!this.consume && this.idvDetect) {
            for (i = 0; i < progress.length; ++i) {
                if (progress[i] >= this.requiredItems.get((int)i).stackSize) continue;
                progress[i] = 0;
            }
        }
        boolean flag = true;
        int[] totalProgress = progress;
        if (this.consume || this.idvDetect) {
            this.setUserProgress(playerID, progress);
            totalProgress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        }
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            rStack = this.requiredItems.get(j);
            if (rStack == null || totalProgress[j] >= rStack.stackSize) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.setComplete(playerID);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74757_a("partialMatch", this.partialMatch);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74757_a("consume", this.consume);
        json.func_74757_a("groupDetect", !this.idvDetect);
        json.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        json.func_74782_a("requiredItems", (NBTBase)itemArray);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.partialMatch = json.func_74767_n("partialMatch");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.consume = json.func_74767_n("consume");
        this.idvDetect = !json.func_74767_n("groupDetect");
        this.autoConsume = json.func_74767_n("autoConsume");
        this.requiredItems = new ArrayList();
        NBTTagList iList = json.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            BigItemStack item;
            NBTBase entry = iList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 10 || (item = JsonHelper.JsonToItemStack((NBTTagCompound)((NBTTagCompound)entry))) == null) continue;
            this.requiredItems.add(item);
        }
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress = new HashMap();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(n);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredItems.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.requiredItems.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            total += (float)progress[i] / (float)rStack.stackSize;
        }
        return total / (float)this.requiredItems.size();
    }

    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskRetrieval(rect, quest, this);
    }

    public boolean canAcceptItem(UUID owner, ItemStack stack) {
        if (owner == null || stack == null || stack.func_190926_b() || !this.consume || this.isComplete(owner) || this.requiredItems.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = this.requiredItems.get(j);
            if (rStack == null || progress[j] >= rStack.stackSize || !ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((String)rStack.oreDict, (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            return true;
        }
        return false;
    }

    public ItemStack submitItem(UUID owner, ItemStack input) {
        ItemStack stack = input;
        if (owner == null || stack == null || stack.func_190926_b() || !this.consume || this.isComplete(owner)) {
            return stack;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredItems.size() && stack != null && !stack.func_190926_b(); ++j) {
            BigItemStack rStack = this.requiredItems.get(j);
            if (rStack == null || progress[j] >= rStack.stackSize) continue;
            int remaining = rStack.stackSize - progress[j];
            if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((String)rStack.oreDict, (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            int removed = Math.min(stack.func_190916_E(), remaining);
            stack.func_190918_g(removed);
            int n = j;
            progress[n] = progress[n] + removed;
            if (stack.func_190916_E() <= 0) break;
        }
        this.setUserProgress(owner, progress);
        if (stack == null || stack.func_190926_b() || stack.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.requiredItems.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.requiredItems.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        int[] total = new int[this.requiredItems.size()];
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            return this.getUsersProgress(uuid);
        }
        for (UUID mem : party.getMembers()) {
            if (mem != null && party.getStatus(mem).ordinal() <= 0) continue;
            int[] progress = this.getUsersProgress(mem);
            for (int i = 0; i < progress.length; ++i) {
                if (this.idvDetect) {
                    total[i] = Math.max(total[i], progress[i]);
                    continue;
                }
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.requiredItems.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null) continue;
            int[] progress = up.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : up;
            for (int i = 0; i < progress.length; ++i) {
                if (this.idvDetect) {
                    total[i] = Math.max(total[i], progress[i]);
                    continue;
                }
                int n = i;
                total[n] = total[n] + progress[i];
            }
        }
        return total;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

