/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.client.gui2.editors.tasks.GuiEditTaskMeeting;
import bq_standard.client.gui2.tasks.PanelTaskMeeting;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskMeeting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskMeeting
implements ITask,
ITaskTickable {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public String idName = "minecraft:villager";
    public int range = 4;
    public int amount = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    public ResourceLocation getFactoryID() {
        return FactoryTaskMeeting.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.meeting";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
    }

    @Override
    public void tickTask(IQuest quest, EntityPlayer player) {
        if (player.field_70173_aa % 60 == 0 && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            this.detect(player, quest);
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (!player.func_70089_S() || this.isComplete(playerID)) {
            return;
        }
        List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a((double)this.range, (double)this.range, (double)this.range));
        ResourceLocation targetID = new ResourceLocation(this.idName);
        Class target = EntityList.getClass((ResourceLocation)targetID);
        if (target == null) {
            return;
        }
        int n = 0;
        for (Entity entity : list) {
            Class<?> subject = entity.getClass();
            ResourceLocation subjectID = EntityList.func_191306_a(subject);
            if (subjectID == null || this.subtypes && !target.isAssignableFrom(subject) || !this.subtypes && !subjectID.equals((Object)targetID)) continue;
            NBTTagCompound subjectTags = new NBTTagCompound();
            entity.func_70039_c(subjectTags);
            if (!this.ignoreNBT && !ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, (boolean)true) || ++n < this.amount) continue;
            this.setComplete(playerID);
            return;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("target", this.idName);
        json.func_74768_a("range", this.range);
        json.func_74768_a("amount", this.amount);
        json.func_74757_a("subtypes", this.subtypes);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.idName = json.func_150297_b("target", 8) ? json.func_74779_i("target") : "minecraft:villager";
        this.range = json.func_74762_e("range");
        this.amount = json.func_74762_e("amount");
        this.subtypes = json.func_74767_n("subtypes");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.targetTags = json.func_74775_l("targetNBT");
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        return json;
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return new GuiEditTaskMeeting(parent, quest, this);
    }

    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskMeeting(rect, quest, this);
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

