/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.jdoc.IJsonDoc;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.client.gui2.tasks.PanelTaskLocation;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.Level;

public class TaskLocation
implements ITask,
ITaskTickable {
    private ArrayList<UUID> completeUsers = new ArrayList();
    public String name = "New Location";
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int dim = 0;
    public int range = -1;
    public boolean visible = false;
    public boolean hideInfo = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskLocation.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.location";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
    }

    @Override
    public void tickTask(IQuest quest, EntityPlayer player) {
        if (player.field_70173_aa % 100 == 0 && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            this.detect(player, quest);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (!player.func_70089_S() || this.isComplete(playerID)) {
            return;
        }
        if (player.field_71093_bK != this.dim || this.range > 0 && !(player.func_70011_f((double)this.x, (double)this.y, (double)this.z) <= (double)this.range)) return;
        if (this.visible && this.range > 0) {
            boolean liquids;
            Vec3d tPos;
            Vec3d pPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            RayTraceResult mop = player.field_70170_p.func_147447_a(pPos, tPos = new Vec3d((double)this.x, (double)this.y, (double)this.z), liquids = false, !liquids, false);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) return;
            this.setComplete(playerID);
            return;
        } else {
            this.setComplete(playerID);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("name", this.name);
        json.func_74768_a("posX", this.x);
        json.func_74768_a("posY", this.y);
        json.func_74768_a("posZ", this.z);
        json.func_74768_a("dimension", this.dim);
        json.func_74768_a("range", this.range);
        json.func_74757_a("visible", this.visible);
        json.func_74757_a("hideInfo", this.hideInfo);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.name = json.func_74779_i("name");
        this.x = json.func_74762_e("posX");
        this.y = json.func_74762_e("posY");
        this.z = json.func_74762_e("posZ");
        this.dim = json.func_74762_e("dimension");
        this.range = json.func_74762_e("range");
        this.visible = json.func_74767_n("visible");
        this.hideInfo = json.func_74767_n("hideInfo");
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        return json;
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers = new ArrayList();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            NBTBase entry = cList.func_179238_g(i);
            if (entry == null || entry.func_74732_a() != 8) continue;
            try {
                this.completeUsers.add(UUID.fromString(((NBTTagString)entry).func_150285_a_()));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskLocation(rect, quest, this);
    }

    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public IJsonDoc getDocumentation() {
        return null;
    }
}

