/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards.loot;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.INBTSaveLoad;
import betterquesting.api2.storage.SimpleDatabase;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;

public class LootRegistry
extends SimpleDatabase<LootGroup>
implements INBTSaveLoad<NBTTagCompound> {
    public static final LootRegistry INSTANCE = new LootRegistry();
    private final Comparator<DBEntry<LootGroup>> groupSorter = Comparator.comparingInt(o -> ((LootGroup)((Object)((Object)o.getValue()))).weight);
    public boolean updateUI = false;

    public int getTotalWeight() {
        DBEntry[] groups = this.getEntries();
        int i = 0;
        for (DBEntry lg : groups) {
            i += ((LootGroup)((Object)lg.getValue())).weight;
        }
        return i;
    }

    public LootGroup getWeightedGroup(float weight, Random rand) {
        int total = this.getTotalWeight();
        if (total <= 0) {
            return null;
        }
        float r = rand.nextFloat() * (float)total / 4.0f + weight * (float)total * 0.75f;
        int cnt = 0;
        DBEntry[] sorted = this.getEntries();
        Arrays.sort(sorted, this.groupSorter);
        for (DBEntry entry : sorted) {
            if (!((float)(cnt += ((LootGroup)((Object)entry.getValue())).weight) >= r)) continue;
            return (LootGroup)((Object)entry.getValue());
        }
        return null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList jRew = new NBTTagList();
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jGrp = ((LootGroup)((Object)entry.getValue())).writeToNBT(new NBTTagCompound());
            jGrp.func_74768_a("ID", entry.getID());
            jRew.func_74742_a((NBTBase)jGrp);
        }
        tag.func_74782_a("groups", (NBTBase)jRew);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.reset();
        ArrayList<LootGroup> legacyGroups = new ArrayList<LootGroup>();
        NBTTagList list = tag.func_150295_c("groups", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            int id = entry.func_150297_b("ID", 99) ? entry.func_74762_e("ID") : -1;
            LootGroup group = new LootGroup();
            group.readFromNBT(entry);
            if (id >= 0) {
                this.add(id, (Object)group);
                continue;
            }
            legacyGroups.add(group);
        }
        for (LootGroup group : legacyGroups) {
            this.add(this.nextID(), (Object)group);
        }
        this.updateUI = true;
    }

    public void updateClients() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound json = new NBTTagCompound();
        INSTANCE.writeToNBT(json);
        tags.func_74782_a("Database", (NBTBase)json);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToAll(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags));
    }

    public void sendDatabase(EntityPlayerMP player) {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound json = new NBTTagCompound();
        INSTANCE.writeToNBT(json);
        tags.func_74782_a("Database", (NBTBase)json);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToPlayer(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags), player);
    }

    public static List<BigItemStack> getStandardLoot(EntityPlayer player) {
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
        LootTable table = player.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186422_d);
        LootContext.Builder lcBuilder = new LootContext.Builder((WorldServer)player.field_70170_p);
        for (ItemStack s : table.func_186462_a(player.func_70681_au(), lcBuilder.func_186471_a())) {
            stacks.add(new BigItemStack(s));
        }
        return stacks;
    }
}

