/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers.hqm;

import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import bq_standard.core.BQ_Standard;
import bq_standard.importers.hqm.converters.items.HQMItem;
import bq_standard.importers.hqm.converters.items.HQMItemBag;
import bq_standard.importers.hqm.converters.items.HQMItemHeart;
import com.google.gson.JsonObject;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class HQMUtilities {
    static HashMap<String, HQMItem> itemConverters = new HashMap();

    public static BigItemStack HQMStackT1(JsonObject json) {
        HQMItem hqm;
        String iID = JsonHelper.GetString((JsonObject)json, (String)"id", (String)"minecraft:stone");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(iID));
        int amount = JsonHelper.GetNumber((JsonObject)json, (String)"amount", (Number)1).intValue();
        int damage = JsonHelper.GetNumber((JsonObject)json, (String)"damage", (Number)0).intValue();
        NBTTagCompound tags = null;
        if (json.has("nbt")) {
            try {
                String rawNbt = json.get("nbt").toString();
                rawNbt = rawNbt.replaceFirst("\"", "");
                rawNbt = rawNbt.substring(0, rawNbt.length() - 1);
                rawNbt = rawNbt.replace(":\\\"", ":\"");
                rawNbt = rawNbt.replace("\\\",", "\",");
                rawNbt = rawNbt.replace("\\\"}", "\"}");
                rawNbt = rawNbt.replace("\\\"]", "\"]");
                rawNbt = rawNbt.replace("[\\\"", "[\"");
                rawNbt = rawNbt.replace("\\n", "\n");
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)rawNbt);
                if (nbt != null && nbt instanceof NBTTagCompound) {
                    tags = nbt;
                }
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to convert HQM NBT data. This is likely a HQM Gson/Json formatting issue", (Throwable)e);
            }
        }
        if ((hqm = itemConverters.get(iID)) != null) {
            return hqm.convertItem(damage, amount, tags);
        }
        if (item == null) {
            item = ItemPlaceholder.placeholder;
            NBTTagCompound tmp = new NBTTagCompound();
            if (tags != null) {
                tmp.func_74782_a("orig_tag", tags);
            }
            tmp.func_74778_a("orig_id", iID);
            tags = tmp;
        }
        BigItemStack stack = new BigItemStack(item, amount, damage);
        if (tags != null) {
            stack.SetTagCompound(tags);
        }
        return stack;
    }

    public static BigItemStack HQMStackT2(JsonObject rJson) {
        int[] oreId;
        HQMItem hqm;
        JsonObject json = JsonHelper.GetObject((JsonObject)rJson, (String)"item");
        String iID = JsonHelper.GetString((JsonObject)json, (String)"id", (String)"minecraft:stone");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(iID));
        int amount = JsonHelper.GetNumber((JsonObject)rJson, (String)"required", (Number)1).intValue();
        int damage = JsonHelper.GetNumber((JsonObject)json, (String)"damage", (Number)0).intValue();
        boolean oreDict = JsonHelper.GetString((JsonObject)rJson, (String)"precision", (String)"").equalsIgnoreCase("ORE_DICTIONARY");
        NBTTagCompound tags = null;
        if (json.has("nbt")) {
            try {
                String rawNbt = json.get("nbt").toString();
                rawNbt = rawNbt.replaceFirst("\"", "");
                rawNbt = rawNbt.substring(0, rawNbt.length() - 1);
                rawNbt = rawNbt.replace(":\\\"", ":\"");
                rawNbt = rawNbt.replace("\\\",", "\",");
                rawNbt = rawNbt.replace("\\\"}", "\"}");
                rawNbt = rawNbt.replace("\\\"]", "\"]");
                rawNbt = rawNbt.replace("[\\\"", "[\"");
                rawNbt = rawNbt.replace("\\n", "\n");
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)rawNbt);
                if (nbt != null && nbt instanceof NBTTagCompound) {
                    tags = nbt;
                }
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to convert HQM NBT data. This is likely a HQM Gson/Json formatting issue", (Throwable)e);
            }
        }
        if ((hqm = itemConverters.get(iID)) != null) {
            return hqm.convertItem(damage, amount, tags);
        }
        if (item == null) {
            item = ItemPlaceholder.placeholder;
            NBTTagCompound tmp = new NBTTagCompound();
            if (tags != null) {
                tmp.func_74782_a("orig_tag", tags);
            }
            tmp.func_74778_a("orig_id", iID);
            tags = tmp;
        }
        BigItemStack stack = new BigItemStack(item, amount, damage);
        if (tags != null) {
            stack.SetTagCompound(tags);
        }
        if (oreDict && (oreId = OreDictionary.getOreIDs((ItemStack)stack.getBaseStack())).length > 0) {
            stack.oreDict = OreDictionary.getOreName((int)oreId[0]);
        }
        return stack;
    }

    public static FluidStack HQMStackT3(JsonObject json) {
        String name = JsonHelper.GetString((JsonObject)json, (String)"fluid", (String)"water");
        Fluid fluid = FluidRegistry.getFluid((String)name);
        int amount = JsonHelper.GetNumber((JsonObject)json, (String)"required", (Number)1000).intValue();
        if (fluid == null) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("orig_id", name);
            FluidStack stack = new FluidStack(FluidPlaceholder.fluidPlaceholder, amount);
            stack.tag = tags;
            return stack;
        }
        return new FluidStack(fluid, amount);
    }

    static {
        itemConverters.put("HardcoreQuesting:hearts", new HQMItemHeart());
        itemConverters.put("HardcoreQuesting:bags", new HQMItemBag());
    }
}

