/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import bq_standard.handlers.ConfigHandler;
import bq_standard.handlers.LootSaveLoad;
import bq_standard.rewards.loot.LootRegistry;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.TaskBlockBreak;
import bq_standard.tasks.TaskCrafting;
import bq_standard.tasks.TaskHunt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventHandler {
    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemCrafted((IQuest)entry.getValue(), event.player, event.crafting.func_77946_l());
            }
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemSmelted((IQuest)entry.getValue(), event.player, event.smelting.func_77946_l());
            }
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskHunt)) continue;
                ((TaskHunt)task.getValue()).onKilledByPlayer((IQuest)entry.getValue(), event.getEntityLiving(), event.getSource());
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.getPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskBlockBreak)) continue;
                ((TaskBlockBreak)task.getValue()).onBlockBreak((IQuest)entry.getValue(), event.getPlayer(), event.getState(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving().field_70173_aa % 60 != 0 || !(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof ITaskTickable)) continue;
                ((ITaskTickable)task.getValue()).tickTask((IQuest)entry.getValue(), player);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("bq_standard")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            LootRegistry.INSTANCE.sendDatabase((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && LootSaveLoad.INSTANCE.worldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            LootSaveLoad.INSTANCE.SaveLoot();
        }
    }
}

