/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.theme;

import betterquesting.api.client.gui.GuiElement;
import betterquesting.api.client.themes.IThemeRenderer;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ThemeRenderStandard
extends GuiElement
implements IThemeRenderer {
    private int[] lineColors = new int[]{new Color(0.75f, 0.0f, 0.0f).getRGB(), Color.YELLOW.getRGB(), Color.GREEN.getRGB(), Color.GREEN.getRGB()};
    private int[] iconColors = new int[]{Color.GRAY.getRGB(), new Color(0.75f, 0.0f, 0.0f).getRGB(), new Color(0.0f, 1.0f, 1.0f).getRGB(), Color.GREEN.getRGB()};

    public void setLineColors(int locked, int incomplete, int complete) {
        this.lineColors[0] = locked;
        this.lineColors[1] = incomplete;
        this.lineColors[2] = complete;
        this.lineColors[3] = complete;
    }

    public void setIconColors(int locked, int incomplete, int pending, int complete) {
        this.iconColors[0] = locked;
        this.iconColors[1] = incomplete;
        this.iconColors[2] = pending;
        this.iconColors[3] = complete;
    }

    public void drawLine(IQuest quest, UUID playerID, float x1, float y1, float x2, float y2, int mx, int my, float partialTick) {
        boolean isMain = quest == null ? false : (Boolean)quest.getProperty(NativeProps.MAIN);
        EnumQuestState qState = quest == null || playerID == null ? EnumQuestState.LOCKED : quest.getState(playerID);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int cl = this.getQuestLineColor(qState);
        float lr = (float)(cl >> 16 & 0xFF) / 255.0f;
        float lg = (float)(cl >> 8 & 0xFF) / 255.0f;
        float lb = (float)(cl & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)lr, (float)lg, (float)lb, (float)1.0f);
        GL11.glLineWidth((float)(isMain ? 8.0f : 4.0f));
        GL11.glEnable((int)2852);
        GL11.glLineStipple((int)8, (short)-1);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)x1, (float)y1);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        GL11.glLineStipple((int)1, (short)Short.MAX_VALUE);
        GL11.glDisable((int)2852);
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawIcon(IQuest quest, UUID playerID, float px, float py, float sx, float sy, int mx, int my, float partialTick) {
        boolean isMain = quest == null ? false : (Boolean)quest.getProperty(NativeProps.MAIN);
        EnumQuestState qState = quest == null || playerID == null ? EnumQuestState.LOCKED : quest.getState(playerID);
        boolean hover = (float)mx >= px && (float)my >= py && (float)mx < px + sx && (float)my < py + sy;
        GlStateManager.func_179094_E();
        int ci = this.getQuestIconColor(qState, qState == EnumQuestState.LOCKED ? 0 : (!hover ? 1 : 2));
        float ir = (float)(ci >> 16 & 0xFF) / 255.0f;
        float ig = (float)(ci >> 8 & 0xFF) / 255.0f;
        float ib = (float)(ci & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)ir, (float)ig, (float)ib, (float)1.0f);
        GlStateManager.func_179109_b((float)px, (float)py, (float)0.0f);
        float sw = sx / 24.0f;
        float sh = sy / 24.0f;
        GlStateManager.func_179152_a((float)sw, (float)sh, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ThemeRenderStandard.currentTheme().getGuiTexture());
        this.drawTexturedModalRect(0, 0, isMain ? 24 : 0, 104, 24, 24);
        if (quest == null) {
            RenderUtils.RenderItemStack((Minecraft)Minecraft.func_71410_x(), (ItemStack)new ItemStack(Items.field_151156_bN), (int)4, (int)4, (String)"");
        } else if (quest.getProperty(NativeProps.ICON) != null) {
            RenderUtils.RenderItemStack((Minecraft)Minecraft.func_71410_x(), (ItemStack)((BigItemStack)quest.getProperty(NativeProps.ICON)).getBaseStack(), (int)4, (int)4, (String)"");
        }
        GlStateManager.func_179121_F();
    }

    private int getQuestLineColor(EnumQuestState state) {
        Color c = new Color(this.lineColors[state.ordinal()]);
        if (state == EnumQuestState.UNLOCKED && Minecraft.func_71386_F() / 1000L % 2L == 0L) {
            return new Color((float)c.getRed() / 255.0f * 0.5f, (float)c.getGreen() / 255.0f * 0.5f, (float)c.getBlue() / 255.0f * 0.5f).getRGB();
        }
        return c.getRGB();
    }

    private int getQuestIconColor(EnumQuestState state, int hoverState) {
        Color c = new Color(this.iconColors[state.ordinal()]);
        if (hoverState == 1) {
            return new Color((float)c.getRed() / 255.0f * 0.75f, (float)c.getGreen() / 255.0f * 0.75f, (float)c.getBlue() / 255.0f * 0.75f).getRGB();
        }
        return c.getRGB();
    }

    public void drawThemedPanel(int x, int y, int w, int h) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(ThemeRenderStandard.currentTheme().getGuiTexture());
        int w2 = w - w % 16;
        int h2 = h - h % 16;
        for (int i = 0; i < w2; i += 16) {
            for (int j = 0; j < h2; j += 16) {
                int tx = 16;
                int ty = 16;
                if (i == 0) {
                    tx -= 16;
                } else if (i == w2 - 16) {
                    tx += 16;
                }
                if (j == 0) {
                    ty -= 16;
                } else if (j == h2 - 16) {
                    ty += 16;
                }
                this.drawTexturedModalRect(x + i, y + j, tx, ty, 16, 16);
            }
        }
    }
}

