/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui2.editors;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.IGuiHelper;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterNumber;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootGroup;
import bq_standard.rewards.loot.LootRegistry;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector4f;

public class GuiEditLootEntry
extends GuiScreenCanvas
implements IVolatileScreen {
    private LootGroup lootGroup;
    private final int groupID;
    private LootGroup.LootEntry selEntry;
    private int selectedID = -1;
    private CanvasScrolling lootList;
    private PanelTextBox fieldName;
    private PanelTextField<Integer> fieldWeight;
    private PanelTextBox textWeight;
    private final DecimalFormat numFormat = new DecimalFormat("0.##");

    public GuiEditLootEntry(GuiScreen parent, LootGroup group) {
        super(parent);
        this.lootGroup = group;
        this.groupID = LootRegistry.INSTANCE.getID((Object)group);
    }

    public void initPanel() {
        super.initPanel();
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        cvBackground.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 16, 16, -32), 0), QuestTranslation.translate((String)"bq_standard.title.edit_loot_groups", (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        CanvasEmpty cvLeft = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 8, 24), 0));
        cvBackground.addPanel((IGuiPanel)cvLeft);
        this.lootList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 24), 0));
        cvLeft.addPanel((IGuiPanel)this.lootList);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 24), 0));
        cvLeft.addPanel((IGuiPanel)scList);
        this.lootList.setScrollDriverY((IValueIO)scList);
        cvLeft.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(0, -16, 0, 0), 0), -1, QuestTranslation.translate((String)"betterquesting.btn.new", (Object[])new Object[0])){

            public void onButtonClick() {
                GuiEditLootEntry.this.lootGroup.add(GuiEditLootEntry.this.lootGroup.nextID(), new LootGroup.LootEntry());
                GuiEditLootEntry.this.sendChanges();
            }
        });
        CanvasEmpty cvRight = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 24), 0));
        cvBackground.addPanel((IGuiPanel)cvRight);
        cvRight.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 4, 0, -16), 0), QuestTranslation.translate((String)"betterquesting.gui.name", (Object[])new Object[0])).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.fieldName = new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), this.selEntry != null ? "#" + this.selectedID : "#--").setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel((IGuiPanel)this.fieldName);
        cvRight.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 36, 0, -48), 0), QuestTranslation.translate((String)"bq_standard.gui.weight", (Object[])new Object[0])).setColor(PresetColor.TEXT_MAIN.getColor()));
        this.fieldWeight = new PanelTextField((IGuiRect)new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.0f), new GuiPadding(0, 48, 0, -64), 0), "" + (this.selEntry != null ? this.selEntry.weight : 1), (IFieldFilter)FieldFilterNumber.INT);
        this.fieldWeight.setCallback(value -> {
            if (this.selEntry == null) {
                return;
            }
            if ((Integer)this.fieldWeight.getValue() <= 0) {
                this.fieldWeight.setText("1");
            }
            this.selEntry.weight = (Integer)this.fieldWeight.getValue();
            int totalWeight = this.lootGroup.getTotalWeight();
            float chance = (float)this.selEntry.weight / (float)totalWeight * 100.0f;
            this.textWeight.setText("/" + totalWeight + " (" + this.numFormat.format(chance) + "%)");
        });
        cvRight.addPanel(this.fieldWeight);
        this.textWeight = new PanelTextBox((IGuiRect)new GuiTransform(new Vector4f(0.5f, 0.0f, 1.0f, 0.0f), new GuiPadding(4, 52, 0, -64), 0), "/1 (100%)").setColor(PresetColor.TEXT_MAIN.getColor());
        cvRight.addPanel((IGuiPanel)this.textWeight);
        GuiEditLootEntry screenRef = this;
        cvRight.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(0, -16, 0, 0), 0), -1, QuestTranslation.translate((String)"bq_standard.btn.add_remove_drops", (Object[])new Object[0]), (GuiScreen)screenRef){
            final /* synthetic */ GuiScreen val$screenRef;
            {
                this.val$screenRef = guiScreen;
                super(x0, x1, x2);
            }

            public void onButtonClick() {
                if (GuiEditLootEntry.this.selEntry != null) {
                    NBTTagCompound eTag = GuiEditLootEntry.this.selEntry.writeToNBT(new NBTTagCompound());
                    ((IGuiHelper)QuestingAPI.getAPI((ApiKey)ApiReference.GUI_HELPER)).openJsonEditor(this.val$screenRef, value -> {
                        LootGroup.LootEntry le;
                        LootGroup lg = (LootGroup)((Object)((Object)LootRegistry.INSTANCE.getValue(GuiEditLootEntry.this.groupID)));
                        LootGroup.LootEntry lootEntry = le = lg == null ? null : (LootGroup.LootEntry)lg.getValue(GuiEditLootEntry.this.selectedID);
                        if (le != null) {
                            le.readFromNBT(eTag);
                            GuiEditLootEntry.this.sendChanges();
                        }
                    }, (NBTBase)eTag.func_150295_c("items", 10), null);
                }
            }
        });
        cvBackground.addPanel((IGuiPanel)new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                GuiEditLootEntry.this.sendChanges();
                GuiEditLootEntry.this.field_146297_k.func_147108_a(GuiEditLootEntry.this.parent);
            }
        });
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -24, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine((IGuiRect)ls0, (IGuiRect)le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel((IGuiPanel)paLine0);
        this.refreshEntries();
    }

    public void drawPanel(int mx, int my, float partialTick) {
        if (LootRegistry.INSTANCE.updateUI) {
            LootRegistry.INSTANCE.updateUI = false;
            this.lootGroup = (LootGroup)((Object)LootRegistry.INSTANCE.getValue(this.groupID));
            if (this.lootGroup == null) {
                this.field_146297_k.func_147108_a(this.parent);
                return;
            }
            if (this.selectedID >= 0) {
                this.selEntry = (LootGroup.LootEntry)this.lootGroup.getValue(this.selectedID);
                if (this.selEntry == null) {
                    this.selectedID = -1;
                    this.fieldName.setText("");
                    this.fieldWeight.setText("1");
                    this.textWeight.setText("/1 (100%)");
                } else {
                    this.selEntry.weight = (Integer)this.fieldWeight.getValue();
                    int totalWeight = this.lootGroup.getTotalWeight();
                    float chance = (float)this.selEntry.weight / (float)totalWeight * 100.0f;
                    this.textWeight.setText("/" + totalWeight + " (" + this.numFormat.format(chance) + "%)");
                }
            }
            this.refreshEntries();
        }
        super.drawPanel(mx, my, partialTick);
    }

    private void refreshEntries() {
        this.lootList.resetCanvas();
        int lWidth = this.lootList.getTransform().getWidth();
        DBEntry[] lgAry = this.lootGroup.getEntries();
        for (int i = 0; i < lgAry.length; ++i) {
            this.lootList.addPanel((IGuiPanel)new PanelButtonStorage((IGuiRect)new GuiRectangle(0, i * 16, 16, 16, 0), -1, "", (Object)lgAry[i]).setCallback(value -> {
                this.lootGroup.removeID(value.getID());
                this.refreshEntries();
                this.sendChanges();
            }).setIcon(PresetIcon.ICON_TRASH.getTexture()));
            this.lootList.addPanel((IGuiPanel)new PanelButtonStorage((IGuiRect)new GuiRectangle(16, i * 16, lWidth - 16, 16, 0), -1, "#" + lgAry[i].getID(), (Object)lgAry[i]).setCallback(value -> {
                if (this.selEntry != null) {
                    this.sendChanges();
                }
                this.selectedID = value.getID();
                this.selEntry = (LootGroup.LootEntry)value.getValue();
                this.fieldName.setText("#" + this.selectedID);
                this.fieldWeight.setText("" + this.selEntry.weight);
                int totalWeight = this.lootGroup.getTotalWeight();
                float chance = (float)this.selEntry.weight / (float)totalWeight * 100.0f;
                this.textWeight.setText("/" + totalWeight + " (" + this.numFormat.format(chance) + "%)");
            }));
        }
    }

    private void sendChanges() {
        NBTTagCompound nbt = new NBTTagCompound();
        LootRegistry.INSTANCE.writeToNBT(nbt);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("ID", 1);
        tags.func_74782_a("Database", (NBTBase)nbt);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(StandardPacketType.LOOT_SYNC.GetLocation(), tags));
    }
}

