/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableMap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmProperties;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ModuleCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.circuits.Circuits;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRubber;
import forestry.farming.logic.farmables.FarmableSapling;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import techreborn.api.ISubItemRetriever;
import techreborn.api.TechRebornAPI;

@ForestryModule(containerID="forestry_compat", moduleID="techreborn", name="TechReborn", author="temp1011", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.techreborn.description")
public class PluginTechReborn
extends CompatPlugin {
    public static final String MOD_ID = "techreborn";
    @GameRegistry.ItemStackHolder(value="techreborn:rubber_log")
    @Nullable
    public static ItemStack RUBBER_WOOD = null;
    @GameRegistry.ItemStackHolder(value="techreborn:rubber_sapling")
    @Nullable
    public static final ItemStack RUBBER_SAPLING = null;
    public static ItemStack sap;
    public static ItemStack rubber;

    public PluginTechReborn() {
        super("TechReborn", MOD_ID);
    }

    @Override
    public void preInit() {
        IFarmProperties rubberFarm = FarmRegistry.getInstance().registerLogic("farmRubber", FarmLogicRubber::new, new String[0]);
        Circuits.farmRubberManual = new CircuitFarmLogic("manualRubber", rubberFarm, true);
    }

    @Override
    @Optional.Method(modid="techreborn")
    public void doInit() {
        ISubItemRetriever getItem = TechRebornAPI.subItemRetriever;
        sap = getItem.getPartByName("rubberSap");
        rubber = getItem.getPartByName("rubber");
    }

    @Override
    @Optional.Method(modid="techreborn")
    public void registerCrates() {
        ItemStack scrap = TechRebornAPI.subItemRetriever.getPartByName("scrap");
        ItemStack uuMatter = this.getItemStack("uumatter");
        ModuleHelper.registerCrate(sap);
        ModuleHelper.registerCrate(scrap);
        ModuleHelper.registerCrate(uuMatter);
        ModuleHelper.registerCrate("ingotLead");
        ModuleHelper.registerCrate("ingotAluminum");
        ModuleHelper.registerCrate("ingotBrass");
        ModuleHelper.registerCrate("ingotNickel");
        if (!ModUtil.isModLoaded("ic2")) {
            ModuleHelper.registerCrate("ingotSilver");
            ModuleHelper.registerCrate("itemRubber");
        }
    }

    @Override
    public void registerBackpackItems() {
        ModuleHelper.addItemToBackpack("forestry.forester", sap);
    }

    @Override
    @Optional.Method(modid="techreborn")
    public void registerRecipes() {
        int bogEarthOutputCan;
        RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), ModuleCore.items.tubes.get(EnumElectronTube.RUBBER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "itemRubber"});
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemRegistryApiculture beeItems = ModuleApiculture.getItems();
            if (!ModUtil.isModLoaded("ic2")) {
                RecipeManagers.centrifugeManager.addRecipe(20, beeItems.propolis.get(EnumPropolis.NORMAL, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)sap, (Object)Float.valueOf(1.0f)));
            } else {
                Log.info("Using ic2 Propolis recipe rather than Tech Reborn", new Object[0]);
            }
        }
        if ((bogEarthOutputCan = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.can")) > 0) {
            ItemStack waterCell = TechRebornAPI.subItemRetriever.getCellByName("water");
            ItemStack bogEarthCan = ModuleCore.getBlocks().bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputCan);
            RecipeUtil.addRecipe("techreborn_bog_earth_can", bogEarthCan, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waterCell, Character.valueOf('Y'), "sand");
        }
        if (ModuleHelper.isEnabled("farming")) {
            ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
            ChipsetManager.solderManager.addRecipe(layoutManual, ModuleCore.items.tubes.get(EnumElectronTube.RUBBER, 1), Circuits.farmRubberManual);
            ForestryAPI.farmRegistry.registerFarmables("rubberTreeFarm", new FarmableSapling(RUBBER_SAPLING, new ItemStack[0]));
        }
    }

    public static boolean rubberItemsSuccess() {
        return ItemStackUtil.getItemFromRegistry("techreborn:rubber_wood") != null && !new ItemStack(ItemStackUtil.getItemFromRegistry("techreborn:part"), 1, 31).func_190926_b();
    }
}

