/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.IClimatised;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmHydrationManager
implements IFarmLedgerDelegate,
INbtWritable,
INbtReadable,
IStreamable {
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_MAX = 15.0f;
    private static final float RAINFALL_MODIFIER_MIN = 0.5f;
    private final IClimatised climatised;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;

    public FarmHydrationManager(IClimatised climatised) {
        this.climatised = climatised;
    }

    public void updateServer(World world, BlockPos coordinates) {
        if (world.func_175727_C(coordinates.func_177984_a())) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
    }

    @Override
    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    @Override
    public float getHydrationTempModifier() {
        float temperature = this.climatised.getExactTemperature();
        return temperature > 0.8f ? temperature : 0.8f;
    }

    @Override
    public float getHydrationHumidModifier() {
        float mod = 1.0f / this.climatised.getExactHumidity();
        return mod < 2.0f ? mod : 2.0f;
    }

    @Override
    public float getHydrationRainfallModifier() {
        float mod = (float)this.ticksSinceRainfall / 24000.0f;
        if (mod <= 0.5f) {
            return 0.5f;
        }
        if (mod >= 15.0f) {
            return 15.0f;
        }
        return mod;
    }

    @Override
    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("HydrationDelay", this.hydrationDelay);
        nbttagcompound.func_74768_a("TicksSinceRainfall", this.ticksSinceRainfall);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.func_150787_b(this.hydrationDelay);
        data.func_150787_b(this.ticksSinceRainfall);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.hydrationDelay = data.func_150792_a();
        this.ticksSinceRainfall = data.func_150792_a();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.hydrationDelay = nbt.func_74762_e("HydrationDelay");
        this.ticksSinceRainfall = nbt.func_74762_e("TicksSinceRainfall");
    }
}

