/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class BlockStateSet
extends AbstractSet<IBlockState> {
    private final Set<IBlockState> blockStates = new HashSet<IBlockState>();
    private final Map<Block, Integer> blocks = new IdentityHashMap<Block, Integer>();

    @Override
    public boolean add(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        Integer count = this.blocks.getOrDefault(block, 0);
        this.blocks.put(block, count + 1);
        return this.blockStates.add(blockState);
    }

    @Override
    public boolean remove(Object o) {
        IBlockState blockState = (IBlockState)o;
        Block block = blockState.func_177230_c();
        Integer count = this.blocks.getOrDefault(block, 0);
        if (count > 0) {
            this.blocks.put(block, count - 1);
        } else {
            this.blocks.remove(block);
        }
        return this.blockStates.remove(blockState);
    }

    @Override
    public boolean contains(Object o) {
        IBlockState blockState = (IBlockState)o;
        Block block = blockState.func_177230_c();
        return this.blocks.containsKey(block) && this.blockStates.contains(blockState);
    }

    @Override
    public void clear() {
        this.blockStates.clear();
        this.blocks.clear();
    }

    @Override
    public Iterator<IBlockState> iterator() {
        return this.blockStates.iterator();
    }

    @Override
    public int size() {
        return this.blockStates.size();
    }
}

