/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.WidgetManager;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class Widget
implements IToolTipProvider {
    protected final WidgetManager manager;
    protected final int xPos;
    protected final int yPos;
    protected int width = 16;
    protected int height = 16;

    public Widget(WidgetManager manager, int xPos, int yPos) {
        this.manager = manager;
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public abstract void draw(int var1, int var2);

    public void update(int mouseX, int mouseY) {
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }

    @Override
    public boolean isToolTipVisible() {
        return true;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPos && mouseX <= this.xPos + this.width && mouseY >= this.yPos && mouseY <= this.yPos + this.height;
    }

    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
    }

    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        return false;
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
    }
}

