/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IDatabasePlugin;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.genetics.IGeneticAnalyzer;
import forestry.api.genetics.IGeneticAnalyzerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.GuiEvent;
import forestry.core.gui.Drawable;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.gui.elements.AbstractItemElement;
import forestry.core.gui.elements.ButtonElement;
import forestry.core.gui.elements.DatabaseElement;
import forestry.core.gui.elements.GeneticAnalyzerTabs;
import forestry.core.gui.elements.ScrollBarElement;
import forestry.core.gui.elements.ScrollableElement;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GeneticAnalyzer
extends ElementGroup
implements IGeneticAnalyzer,
IScrollable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/analyzer_screen.png");
    public static final Drawable SCROLLBAR_BACKGROUND = new Drawable(TEXTURE, 202, 0, 3, 142);
    public static final Drawable SCROLLBAR_SLIDER = new Drawable(TEXTURE, 205, 0, 3, 5);
    public static final Drawable SELECTION_BAR = new Drawable(TEXTURE, 70, 166, 107, 32);
    public static final Drawable ANALYZER_BUTTON = new Drawable(TEXTURE, 163, 40, 22, 25);
    private final IGeneticAnalyzerProvider provider;
    private final ScrollBarElement scrollBar;
    private final ScrollableElement scrollable;
    private final DatabaseElement scrollableContent;
    private final GeneticAnalyzerTabs tabs;
    private final IGuiElement itemElement;
    private final ButtonElement leftButton;
    private final ButtonElement rightButton;
    private final ButtonElement analyzeButton;
    private int selectedSlot = -1;

    public GeneticAnalyzer(IWindowElement window, int xPos, int yPos, boolean rightBoarder, final IGeneticAnalyzerProvider provider) {
        super(xPos - (rightBoarder ? 6 : 0), yPos, 189 + (rightBoarder ? 6 : 0), 194);
        window.add(this);
        this.provider = provider;
        this.drawable(32, 0, new Drawable(TEXTURE, 0, 0, 163 + (rightBoarder ? 0 : -6), 166));
        this.scrollable = new ScrollableElement(42, 8, 145, 150);
        this.add(this.scrollable);
        this.scrollableContent = new DatabaseElement(145);
        this.scrollable.setContent(this.scrollableContent);
        this.scrollable.add(this.scrollableContent);
        this.scrollBar = new ScrollBarElement(this.width - 10 - (rightBoarder ? 6 : 0), 12, SCROLLBAR_BACKGROUND, false, SCROLLBAR_SLIDER);
        this.scrollBar.hide();
        this.add(this.scrollBar);
        this.tabs = new GeneticAnalyzerTabs(0, 5, this);
        this.add(this.tabs);
        this.itemElement = this.drawable((this.getWidth() + 32 - GeneticAnalyzer.SELECTION_BAR.uWidth) / 2, 162, SELECTION_BAR);
        this.leftButton = this.add(new ButtonElement(this.itemElement.getX() + 30, this.itemElement.getY() + 9, StandardButtonTextureSets.LEFT_BUTTON, button -> this.subtract()));
        this.rightButton = this.add(new ButtonElement(this.itemElement.getX() + 64, this.itemElement.getY() + 9, StandardButtonTextureSets.RIGHT_BUTTON, button -> this.add()));
        this.analyzeButton = this.add(new ButtonElement(this.itemElement.getX() + 80, this.itemElement.getY() + 2, ANALYZER_BUTTON, button -> NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, provider.getSelectedSlot(this.selectedSlot)))));
        this.add(new AbstractItemElement(this.itemElement.getX() + 44, this.itemElement.getY() + 9){

            @Override
            protected ItemStack getStack() {
                return provider.getSpecimen(GeneticAnalyzer.this.selectedSlot);
            }
        });
        this.addEventHandler(GuiEvent.KeyEvent.class, event -> {
            int keyCode = event.getKey();
            if ((keyCode == 208 || keyCode == 205) && this.rightButton.isEnabled()) {
                this.rightButton.onPressed();
            } else if ((keyCode == 200 || keyCode == 203) && this.leftButton.isEnabled()) {
                this.leftButton.onPressed();
            } else if (keyCode == 28 && this.analyzeButton.isEnabled()) {
                this.analyzeButton.onPressed();
            }
        });
    }

    @Override
    public void init() {
        this.leftButton.setEnabled(this.canSubtract());
        this.rightButton.setEnabled(this.canAdd());
        this.updateSelected();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public IGeneticAnalyzerProvider getProvider() {
        return this.provider;
    }

    @Override
    public IGuiElement getItemElement() {
        return this.itemElement;
    }

    @Override
    public void update() {
        IIndividual individual;
        IDatabasePlugin databasePlugin;
        if (!this.isVisible()) {
            return;
        }
        ItemStack stack = this.provider.getSpecimen(this.selectedSlot);
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root != null && (databasePlugin = root.getSpeciesPlugin()) != null && (individual = root.getMember(stack)) != null) {
            if (individual.isAnalyzed()) {
                this.tabs.setPlugin(databasePlugin);
                IDatabaseTab tab = this.tabs.getSelected();
                this.scrollableContent.clear();
                this.scrollableContent.init(tab.getMode(), individual, this.scrollableContent.getWidth() / 2, 0);
                tab.createElements(this.scrollableContent, individual, stack);
                int invisibleArea = this.scrollable.getInvisibleArea();
                if (invisibleArea > 0) {
                    this.scrollBar.setParameters(this, 0, invisibleArea, 1);
                    this.scrollBar.show();
                } else {
                    this.scrollBar.setValue(0);
                    this.scrollBar.hide();
                }
                return;
            }
            this.tabs.setPlugin(null);
        }
        this.scrollableContent.clear();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String key = "for.gui.portablealyzer.help";
        List lines = fontRenderer.func_78271_c(Translator.translateToLocal(key), this.scrollable.getWidth());
        for (String text : lines) {
            this.scrollableContent.label(text);
        }
        this.scrollBar.hide();
    }

    @Override
    public void drawTooltip(GuiScreen gui, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver();
    }

    @Override
    public void onScroll(int value) {
        this.scrollable.onScroll(value);
    }

    private boolean canAdd() {
        return this.selectedSlot + 1 < this.getSlotCount();
    }

    private boolean canSubtract() {
        int selectedSlot = this.selectedSlot - 1;
        return selectedSlot < this.getSlotCount() && selectedSlot >= 0;
    }

    public void add() {
        this.setSelectedSlot(this.selectedSlot + 1);
    }

    private void subtract() {
        this.setSelectedSlot(this.selectedSlot - 1);
    }

    private int getSlotCount() {
        return this.provider.getSlotCount();
    }

    @Override
    public void setSelectedSlot(int selectedSlot) {
        int oldSelected = this.selectedSlot;
        this.selectedSlot = selectedSlot;
        this.onSelection(selectedSlot, oldSelected != selectedSlot);
    }

    private void onSelection(int selectedSlot, boolean changed) {
        this.leftButton.setEnabled(this.canSubtract());
        this.rightButton.setEnabled(this.canAdd());
        if (changed) {
            this.update();
        }
        this.provider.onSelection(selectedSlot, changed);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void updateSelected() {
        if (this.provider.onUpdateSelected()) {
            return;
        }
        int slotCount = this.getSlotCount();
        if (slotCount <= 0) {
            this.setSelectedSlot(-1);
            return;
        }
        if (slotCount > this.selectedSlot && this.selectedSlot != -1) {
            return;
        }
        this.setSelectedSlot(this.provider.getFirstSlot());
    }

    @Override
    public int getSelected() {
        return this.selectedSlot;
    }
}

